<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProjectFormRelation extends Model
{
    use HasFactory;

    protected $fillable = [
        'project_id',
        'form_id'
    ];

    public function project()
    {
        return $this->belongsTo(Project::class, 'project_id');
    }

    public function form()
    {
        return $this->belongsTo(Form::class, 'form_id');
    }
}
