<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProjectForm extends Model
{
    use HasFactory;
    protected $fillable = [
        'serial_number',
        'expiration_date',
        'status',
    ];

    public function project()
    {
        return $this->belongsTo(Project::class);
    }

    public function form()
    {
        return $this->belongsTo(Form::class);
    }

    public function projectFormInputs()
    {
        return $this->hasMany(ProjectFormInput::class);
    }
}
