<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;

use Illuminate\Database\Eloquent\Model;
use Laravel\Sanctum\HasApiTokens;
use Tymon\JWTAuth\Contracts\JWTSubject;

class Project extends Authenticatable implements JWTSubject
{
    use HasFactory, HasApiTokens;

    protected $table = 'projects';
    protected $primaryKey = 'id';
    protected $fillable = ['name', 'email', 'password', 'branch_id', 'hse_manager_name', 'fcm_token'];

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function projectForms()
    {
        return $this->hasMany(ProjectForm::class);
    }

    public function forms()
    {
        return $this->belongsToMany(Form::class, 'project_form_relations', 'project_id', 'form_id');
    }

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password'
    ];

    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    public function getJWTCustomClaims()
    {
        return [];
    }
}
