<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FormInput extends Model
{
    use HasFactory;
    protected $fillable = [
        'label',
        'input_type',
        'calculated',
    ];

    public function form()
    {
        return $this->belongsTo(Form::class);
    }

    public function projectFormInputs()
    {
        return $this->hasMany(ProjectFormInput::class);
    }
}
