<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Form extends Model
{
    use HasFactory;
    protected $fillable = [
        'branches',
        'step',
        'name',
        'periodic_onetime',
        'periodic_type',
        'dead_line_by_num_of_dayes',
        'week_day',
        'month_day',
        'quarter_start_date',
        'nex_send_date',
    ];

    public function formFiles()
    {
        return $this->hasMany(FormFile::class);
    }

    public function formInputs()
    {
        return $this->hasMany(FormInput::class);
    }

    public function projectForms()
    {
        return $this->hasMany(ProjectForm::class);
    }

    public function projects()
    {
        return $this->belongsToMany(Project::class, 'project_form_relations', 'form_id', 'project_id');
    }
}
