<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;


class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index(Request $request)
    {
        if ($request->has('type')) {
            $type = $request->type;
        } else {
            $type = null;
        }
        return view('front_end.home', compact('type'));
    }

    public function changeLanguage(Request $request)
    {
        if ($request->locale == 'ar') {
            $changed_to = 'Arabic';
        } else {
            $changed_to = 'English';
        }
        App::setLocale($request->locale);
        $request->session()->put('locale', $request->locale);
        session()->flash('notif', trans('messages.Language changed to ' . $changed_to));
    }
}
