<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Page;
use Illuminate\Http\Request;

class PageController extends Controller
{
    public function pages()
    {
        $pages = Page::select('id', 'title')->get();
        return response()->json(['success' => true, 'pages' => $pages]);
    }

    public function getPageById($id)
    {
        $page = Page::where('id', $id)->first();
        return response()->json(['success' => true, 'pages' => $page]);
    }
}
