<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Form;
use App\Models\ProjectForm;
use App\Models\ProjectFormInput;
use Illuminate\Http\Request;

class FormController extends Controller
{
    public function projectForms(Request $request)
    {
        $name = ($request->has('name')) ? $request->name : null;
        $serial_number = ($request->has('serial_number')) ? $request->serial_number : null;
        $status = ($request->has('status')) ? $request->status : null;
        $from = ($request->has('from')) ? $request->from : null;
        $to = ($request->has('to')) ? $request->to : null;

        $forms = ProjectForm::where('project_id', auth('api')->user()->id)
            ->when($status, function ($q, $status) {
                $q->whereIn('status', explode(',', $status));
            })
            ->when($name, function ($q, $name) {
                $q->whereHas('form', function ($q) use ($name) {
                    $q->where('name', 'like', '%' . $name . '%');
                });
            })
            ->when($serial_number, function ($q, $serial_number) {
                $q->where('serial_number', 'like', '%' . $serial_number . '%');
            })
            ->when($from && $to, function ($q) use ($from, $to) {
                $q->whereBetween('created_at', [$from, $to]);
            })
            ->with('form')
            ->paginate(10);

        return response()->json(['success' => true, 'forms' => $forms]);
    }

    public function getFormFields(Request $request)
    {
        $projectForm = ProjectForm::where('id', $request->project_form_id)
            ->with('form.formFiles')
            ->first();
        $formInputs = ProjectFormInput::with('formInput')
            ->where('project_form_id', $request->project_form_id)
            ->paginate(5);

        return response()->json(['success' => true, 'inputs' => $formInputs, 'projectForm' => $projectForm]);
    }

    public function submitFormInputs(Request $request)
    {
        foreach ($request->inputs as $key => $value) {
            $projectFormInput = ProjectFormInput::find($value['id']);
            switch ($value['type']) {
                case 'file':
                    $file_path = uploadFile($value['value']['data'], $value['value']['mime']);
                    $projectFormInput->answer = $file_path;
                    $projectFormInput->file_type = $value['value']['mime'];
                    break;
                default:
                    $projectFormInput->answer = $value['value'];
                    break;
            }
            $projectFormInput->save();
        }
        $checkFormDone = ProjectFormInput::where('project_form_id', $request->project_form_id)->whereNull('answer')->get();
        $projectFormUpdate = ProjectForm::find($request->project_form_id);
        if (sizeof($checkFormDone) > 0) {
            $projectFormUpdate->status = 'incomplete';
            $projectFormUpdate->save();
        } else {
            $projectFormUpdate->status = 'done';
            $projectFormUpdate->save();
        }

        $projectForm = ProjectForm::where('id', $request->project_form_id)
            ->with('form.formFiles')
            ->first();
        switch ($request->next_prev) {
            case 'next':
                if ($request->next_page_url != null) {
                    $formInputs = ProjectFormInput::with('formInput')
                        ->where('project_form_id', $request->project_form_id)
                        ->paginate(5, ['*'], 'page', $request->next_page_url);
                } else {
                    $formInputs = null;
                }
                return response()->json(['success' => true, 'inputs' => $formInputs, 'projectForm' => $projectForm]);
                break;

            case 'prev':
                if ($request->prev_page_url != null) {
                    $formInputs = ProjectFormInput::with('formInput')
                        ->where('project_form_id', $request->project_form_id)
                        ->paginate(5, ['*'], 'page', $request->prev_page_url);
                } else {
                    $formInputs = null;
                }
                return response()->json(['success' => true, 'inputs' => $formInputs, 'projectForm' => $projectForm]);
                break;

            default:
                # code...
                break;
        }
        return response()->json(['success' => true, 'inputs' => null, 'projectForm' => $projectForm]);
    }
}
