<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;

use App\Models\ProjectForm;
use App\Http\Requests\StoreProjectFormRequest;
use App\Http\Requests\UpdateProjectFormRequest;
use App\Mail\ProjectFormEmail;
use App\Models\Form;
use App\Models\ProjectFormInput;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Traits\FirebaseNotification;
use Illuminate\Support\Facades\Mail;


class ProjectFormController extends Controller
{
    use FirebaseNotification;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $sort_search = null;
        $forms = ProjectForm::orderBy('created_at', 'desc');
        if ($request->has('search')) {
            $sort_search = $request->search;
            $forms = $forms->where('serial_number', 'like', '%' . $sort_search . '%');
        }
        $forms = $forms->paginate(15);
        return view('admin.projectForm.index', compact('forms', 'sort_search'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreProjectFormRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreProjectFormRequest $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\ProjectForm  $projectForm
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $projectForm = ProjectForm::where('id', $id)
            ->with('form.formFiles')
            ->first();
        $formInputs = ProjectFormInput::with('formInput')
            ->where('project_form_id', $id)
            ->get();
        return view('admin.projectForm.show', compact('projectForm', 'formInputs'));
    }

    public function updateExpiration()
    {
        $forms = ProjectForm::where('expiration_date', '<', Carbon::now())->whereIn('status', ['waiting', 'incomplete'])->get();
        foreach ($forms as $key => $form) {
            $form->status = 'expired';
            $form->save();
            //send notifications and mail
            $title = "Hello, " . $form->project->name;
            $type = "form_expired";
            $form_id = $form->id;
            $message = "Hello, " . $form->project->name . "Form " . $form->name . "Petrojet HSE form builder Expired soon Hury to fill it now.";
            if ($form->project->fcm_token) {
                $this->sendNotification($form->project->id, $title, $message, $type, $form_id);
            }
            Mail::to($form->project->email)->send(new ProjectFormEmail($form->project->name, $form->form->name, $form_id, $type));
        }
        return response()->json(['success' => true]);
    }

    public function publishForms()
    {
        $publishForms = Form::where('nex_send_date', date('Y-m-d'))->get();
        foreach ($publishForms as $key => $form) {
            foreach ($form->projects as $project) {
                switch ($form->periodic_type) {
                    case 'week':
                        $form->nex_send_date = date('Y-m-d', strtotime('+7 day'));
                        break;
                    case 'month':
                        $form->nex_send_date = date('Y-m-d', strtotime('+31 day'));
                        break;
                    case 'quarter':
                        $form->nex_send_date = date('Y-m-d', strtotime('+91 day'));
                        break;
                    default:
                        # code...
                        break;
                }
                $form->save();
                $now = Carbon::now();
                $date = $now->addDays($form->dead_line_by_num_of_dayes);
                $projectForm = new ProjectForm;
                $projectForm->serial_number = Str::random(10);
                $projectForm->project_id = $project->id;
                $projectForm->form_id = $form->id;
                $projectForm->expiration_date = $date;
                // return $projectForm;
                $projectForm->save();
                foreach ($form->formInputs as $key => $value) {
                    $projectFormInput = new ProjectFormInput;
                    $projectFormInput->project_form_id = $projectForm->id;
                    $projectFormInput->form_input_id = $value->id;
                    $projectFormInput->input_type = $value->input_type;
                    $projectFormInput->calculated = $value->calculated;
                    $projectFormInput->save();
                }
                //send notifications and mail
                $title = "Hello, " . $project->name;
                $type = "fill_form";
                $form_id = $projectForm->id;
                $message = "Hello, " . $project->name . "New Publishable Form " . $form->name . "Petrojet HSE form builder should be filled";
                if ($project->fcm_token) {
                    $this->sendNotification($project->id, $title, $message, $type, $form_id);
                }
                Mail::to($form->project->email)->send(new ProjectFormEmail($form->project->name, $form->name, $form_id, $type));
            }
        }
        return response()->json(['success' => true]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\ProjectForm  $projectForm
     * @return \Illuminate\Http\Response
     */
    public function edit(ProjectForm $projectForm)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateProjectFormRequest  $request
     * @param  \App\Models\ProjectForm  $projectForm
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateProjectFormRequest $request, ProjectForm $projectForm)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\ProjectForm  $projectForm
     * @return \Illuminate\Http\Response
     */
    public function destroy(ProjectForm $projectForm)
    {
        //
    }
}
