<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Form;
use App\Models\ProjectForm;
use Illuminate\Http\Request;
use Carbon\Carbon;

class HomeController extends Controller
{
    public function dashboard()
    {
        $Expirforms = ProjectForm::where('expiration_date', '<', Carbon::now())->whereIn('status', ['waiting', 'incomplete'])->get();
        $publishForms = Form::where('nex_send_date', date('Y-m-d'))->get();
        $forms = ProjectForm::orderBy('created_at', 'desc')->take(10)->get();
        return view('admin.dashboard', compact('Expirforms', 'publishForms', 'forms'));
    }
}
