<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;

use App\Models\Branch;
use App\Http\Requests\StoreBranchRequest;
use App\Http\Requests\UpdateBranchRequest;
use App\Models\Project;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class BranchController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $sort_search = null;
        $branches = Branch::orderBy('created_at', 'desc');
        if ($request->has('search')) {
            $sort_search = $request->search;
            $branches = $branches->where('name', 'like', '%' . $sort_search . '%');
        }
        $branches = $branches->paginate(20);
        return view('admin.branch.index', compact('branches', 'sort_search'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.branch.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreBranchRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreBranchRequest $request)
    {
        $branch = new Branch;
        $branch->name = $request->name;
        $branch->save();
        return redirect()->route('branch.index');
    }

    public function uploadBranchExcelFile(Request $request)
    {
        $file = $request->file('file');
        $data = Excel::toArray([], $file)[0];
        foreach ($data as $key => $value) {
            if ($key != 0) {
                Branch::firstOrCreate(
                    ['name' =>  $value[0]]
                );
            }
        }
        return response()->json(['success' => true]);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Branch  $branch
     * @return \Illuminate\Http\Response
     */
    public function show(Branch $branch)
    {
        $projects = Project::where('branch_id', $branch->id)->orderBy('created_at', 'desc')->get();
        return view('admin.branch.show', compact('branch', 'projects'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Branch  $branch
     * @return \Illuminate\Http\Response
     */
    public function edit(Branch $branch)
    {
        return view('admin.branch.edit', compact('branch'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateBranchRequest  $request
     * @param  \App\Models\Branch  $branch
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateBranchRequest $request, Branch $branch)
    {
        $branch->name = $request->name;
        $branch->save();
        return redirect()->route('branch.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Branch  $branch
     * @return \Illuminate\Http\Response
     */
    public function destroy(Branch $branch)
    {
        $branch->delete();
        session()->flash('notif', trans('messages.Branch deleted successfully'));
        return redirect()->route('branch.index');
    }
}
