<?php

namespace App\Console;

use App\Console\Commands\ExpireFormsCron;
use App\Console\Commands\PublishFormCron;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        ExpireFormsCron::class,
        PublishFormCron::class,
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        // $schedule->command('ExpireForms:cron')->dailyAt('10:00');
        // $schedule->command('ExpireForms:cron')->everyMinute();
        // $schedule->command('publishForm:cron')->everyMinute();
        // $schedule->command('publishForm:cron')->daily('11:00');
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}
