@forelse ($forms as $key => $form)
    @switch($form->status)
        @case('waiting')
            <tr>
                <td>{{ $loop->iteration + (($forms->currentPage() ?? 0 ) - 1) * (($forms->perPage()?? 0) + 1 )}}</td>
                <td>{{ $form->form->name }}</td>
                 <td style="overflow-x: auto;">{{ $form->form->desc }}</td>
                <td>
                    {{ date('M j, Y', strtotime($form->created_at)) }}</td>
                <td>{{ date('M j, Y', strtotime($form->expiration_date)) }}</td>
                <td class="text-end">
                    <a style="text-decoration: none" href="{{ route('fillForm', $form->id) }}"
                       class="view-button bg-blue">

                        {{__('messages.View')}}
                    </a>

                </td>
            </tr>
            @break

        @case('incomplete')
            <tr>
                <td>{{ $loop->iteration + (($forms->currentPage() ?? 0 ) - 1) * (($forms->perPage()?? 0) + 1 )}}</td>
                <td>{{ $form->form->name }}</td>
                <td style="overflow-x: auto;">{{ $form->form->desc }}</td>
                <td>
                    {{ date('M j, Y', strtotime($form->created_at)) }}</td>
                <td>{{ date('M j, Y', strtotime($form->expiration_date)) }}</td>
                <td class="text-end">
                    <a style="text-decoration: none" href="{{ route('fillForm', $form->id) }}"
                       class="view-button bg-purple">
                        {{__('messages.View')}}
                    </a>
                </td>
            </tr>
            @break

        @case('expired')
            <tr>
                <td>{{ $loop->iteration + (($forms->currentPage() ?? 0 ) - 1) * (($forms->perPage()?? 0) + 1 )}}</td>
                <td>{{ $form->form->name }}</td>
                 <td style="overflow-x: auto;">{{ $form->form->desc }}</td>
                <td>
                    {{ date('M j, Y', strtotime($form->created_at)) }}</td>
                <td>{{ date('M j, Y', strtotime($form->expiration_date)) }}</td>
                <td class="text-end">
                    <a style="text-decoration: none" href="{{ route('fillForm', $form->id) }}"
                       class="view-button bg-red">
                        {{__('messages.View')}}
                    </a>
                </td>
            </tr>
            @break

        @case('done')
            <tr>
                <td>{{ $loop->iteration + (($forms->currentPage() ?? 0 ) - 1) * (($forms->perPage()?? 0) + 1 )}}</td>
                <td>{{ $form->form->name }}</td>
                <td style="overflow-x: auto;">{{ $form->form->desc }}</td>

                <td>
                    {{ date('M j, Y', strtotime($form->created_at)) }}</td>
                <td>{{ date('M j, Y', strtotime($form->expiration_date)) }}</td>
                <td class="text-end">
                    <a style="text-decoration: none" href="{{ route('viewForm', $form->id) }}"
                       class="view-button bg-green">
                        {{__('messages.View')}}
                    </a>
                </td>
            </tr>
            @break
        @case('approved')
            <tr>
                <td>{{ $loop->iteration + (($forms->currentPage() ?? 0 ) - 1) * (($forms->perPage()?? 0) + 1 )}}</td>
                <td>{{ $form->form->name }}</td>
            <td style="overflow-x: auto;">{{ $form->form->desc }}</td>
                <td>
                    {{ date('M j, Y', strtotime($form->created_at)) }}</td>
                <td>{{ date('M j, Y', strtotime($form->expiration_date)) }}</td>
                <td class="text-end">
                    <a style="text-decoration: none" href="{{ route('viewForm', $form->id) }}"
                       class="view-button bg-green">
                        {{__('messages.View')}}
                    </a>
                </td>
            </tr>
            @break
        @case('rejected')
            <tr>
                <td>{{ $loop->iteration + (($forms->currentPage() ?? 0 ) - 1) * (($forms->perPage()?? 0) + 1 )}}</td>
                <td>{{ $form->form->name }}</td>
                 <td style="overflow-x: auto;">{{ $form->form->desc }}</td>
                <td>
                    {{ date('M j, Y', strtotime($form->created_at)) }}</td>
                <td>{{ date('M j, Y', strtotime($form->expiration_date)) }}</td>
                <td class="text-end">
                    <a style="text-decoration: none" href="{{ route('viewForm', $form->id) }}"
                       class="view-button bg-red">
                        {{__('messages.View')}}
                    </a>
                </td>
            </tr>
            @break
        @case('waiting approved')
            <tr>
                <td>{{ $loop->iteration + (($forms->currentPage() ?? 0 ) - 1) * (($forms->perPage()?? 0) + 1 )}}</td>
                <td>{{ $form->form->name }}</td>
               <td style="overflow-x: auto;">{{ $form->form->desc }}</td>
                <td>
                    {{ date('M j, Y', strtotime($form->created_at)) }}</td>
                <td>{{ date('M j, Y', strtotime($form->expiration_date)) }}</td>
                <td class="text-end">
                    <a style="text-decoration: none" href="{{ route('viewForm', $form->id) }}"
                       class="view-button bg-blue">
                        {{__('messages.View')}}
                    </a>
                </td>
            </tr>
            @break

        @default
    @endswitch

@empty
@endforelse
