@extends('layouts.front')

@section('content')

    <style>
        .bootstrap-tagsinput {
            width: 100%;
            padding: 0.6em;
        }

        .box {
            border-top: 20px solid #C4161C;
            border-radius: 20px;
            border-bottom: 20px solid #C4161C !important;
            box-shadow: none !important;
        }

        .box-header {
            border-bottom: 13px solid #f8f8fb;
        }

        .input-group .input-group-text {

            border-color: #C4161C
        }

        .form-name input {
            border-left: none;
        }

        .btn-filled {
            background-color: #000000 !important;
            border: none
        }

        .add-new-field {
            border-right: 2px solid #000000;
        }

        .add-new-field i {
            cursor: pointer;
            font-size: 1.5em;
            position: absolute;
            bottom: 15px;
            right: 5px;
        }

        .theme-primary [type=radio]:checked+label:after {
            border: 2px solid #C4161C;
            background-color: #C4161C;
        }

        .progress {
            position: relative;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: white;
            overflow: hidden;
            background-image: conic-gradient(red 0%, rgba(255, 136, 136, 0.644) 0);
        }

        .progress .inner {
            display: flex;
            justify-content: center;
            align-items: center;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 34px;
            height: 34px;
            background: white;
            border-radius: 50%;
            font-size: 1em;
            font-weight: 400;
        }
        .content .content-wrapper {
            height: 70vh;
            display: flex;
            align-items: center;
            justify-content: center;
            width: 100%;
        }
        .content .content-wrapper .form-group {
            margin-inline: 0.7rem;
            margin-bottom: 0.7rem;
        }
        .box .box-header h3{
            padding-block: 1rem
        }
    </style>
    <!-- Main content -->

    <section class="content">
        <div class="row content-wrapper">
            <div class="col-lg-8 mx-auto">

                <div class="box">
                    <div class="box-header mb-3">
                        <h3 class="text-center">{{ trans('messages.General Report') }}</h3>
                    </div>
                    <div class="box-body">
                        {!! Form::open(['route' => 'branch.report.fixedGetGeneral', 'files' => true, 'id' => 'report-form', 'method' => 'GET']) !!}
                        <div class="form-group">
                            <label for="name">{{ trans('messages.Form') }}
                            </label>
                            <div>
                                {!! Form::select('form_id', $forms, null, [
                                    'class' => 'form-control select2',
                                    'style' => 'width:100%',
                                    'id' => 'form_id',
                                    'required' => 'required',
                                    'data-placeholder' => trans('messages.Form'),
                                ]) !!}
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="name">{{ trans('messages.Project') }}
                            </label>
                            <div>
                                {!! Form::select('projects[]', $projects, null, [
                                    'class' => 'form-control select2',
                                    'style' => 'width:100%',
                                    'id' => 'branch_id',
                                    'multiple' => 'multiple',
                                    'required' => 'required',
                                    'data-placeholder' => trans('messages.Project'),
                                ]) !!}
                            </div>
                        </div>
                        <div class="project-container">
                        </div>
                        <div class="row">
                            <div class="col">
                                <div class="form-group" id="from_date">
                                    <label for="month_day">{{ trans('messages.From') }}</label>
                                    <input type="date" name="from_date" required class="form-control">
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-group" id="to_date">
                                    <label for="month_day">{{ trans('messages.To') }}</label>
                                    <input type="date" name="to_date" required class="form-control">
                                </div>
                            </div>
                        </div>
                        <br>
                        <hr>

                            <button type="submit"
                                    class="btn btn-rounded btn-primary btn-filled form-control">{{ trans('messages.View') }}
                            </button>

                        {!! Form::Close() !!}
                    </div>
                </div>

                <!-- /.box-body -->

            </div>
        </div>

    </section>

@endsection
@section('script')
    <script type="text/javascript">
        $(document).ready(function() {
            $("#form_id").select2();
            $("#branch_id").select2({
                multiple: true
            });
        });
    </script>

@endsection
