<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Petrojet Projects</title>
    <link rel="stylesheet" href="{{ url('front_end/assets/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ url('front_end/assets/css/style.css') }}">
    <link rel="stylesheet" href="{{ url('front_end/assets/css/all.min.css') }}">
    <link rel="stylesheet" href="{{ url('front_end/assets/css/select2.min.css') }}">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Fira+Sans&display=swap" rel="stylesheet">

    <style>
        .login-page {
            width: 100%;
            height: 100vh;
            overflow: hidden;
            margin: 0 !important;
            align-items: center;
        }

        .login-page .img-part {
            height: 100vh;
            margin: 0 !important;
            padding: 0 !important;
        }
        .login-page .img-part img {
            width: 100%;
            height: 100%;
            object-fit: fill;
        }

        .login-page .form-part form {
            width: 70%;
            margin-inline: auto;
        }

        .login-page .form-part {
            margin-top: 6rem
        }
        .login-page .form-part h2 {
            width: 70%;
            margin-inline: auto;
            border-bottom:1px solid #8080805c;
            padding-bottom:0.5rem;
            margin-bottom: 2rem;
        }

        .login-page .logo {
            width:80%;
            margin-inline: auto;
            border-bottom:1px solid #8080805c;
            padding-bottom:0.5rem;
            margin-bottom: 2rem;
        }

        @media(max-width: 1300px) {
            .login-page .form-part form, .login-page .form-part h2{
                width: 80%;
            }
        }
        @media(max-width: 576px) {
            .login-page .img-part {
                display: none;
            }
        }
        .form-part .login-form .select-group .group-wrapper {
            border: 1px solid #ddd;
            border-radius: 5px;
            padding: 10px 0px;
            position: relative;
            text-align: center;
            margin-top: 1em;
        }
        .form-part .login-form .select-group .group-wrapper img{
            width: 30px;
            height: 30px;
            -o-object-fit: contain;
            object-fit: contain;
            display: inline-block;
            position: absolute;
            left: 10px;
            top: 50%;
            transform: translateY(-50%);
            z-index: 9;
        }
        .form-part .login-form .select2-container--default .select2-selection--single {
            border: none;
        }
        .form-part .login-form .password-row {
            padding-right: 12px;
            padding-left: 12px;
        }
        .form-part .login-form .password {
            position: relative;
            border: 1px solid #ddd;
            border-radius: 5px;
            padding: 7px;
            margin-top: 1em;
        }
        .form-part .login-form .password img{
            width: 30px;
            height: 30px;
            -o-object-fit: contain;
            object-fit: contain;
            display: inline-block;
        }
        .form-part .login-form .password input{
            display: inline-block;
            width: 80%;
            border: 0 !important;
            box-shadow: none;
            outline: none;
        }
        .form-part .login-form .password .view-password{
            position: absolute;
            right: 0.7rem;
            top: 50%;
            transform: translateY(-50%);
            width: -moz-fit-content;
            width: fit-content;
            background-color: transparent;
            border: none;
        }
        .form-part .login-form .login-btn {
            margin-top: 2em;
            text-align: center;
            background-color: var(--Red);
            color: var(--White);
            width: 100%;
        }
    </style>
</head>

<body>
    <!-- <nav class="navbar">
        <div class="container-fluid">
            <div class="container">
                <a class="navbar-brand" href="#">
                    <img src="{{ url('front_end/assets/imgs/petrojet-logo.png') }}" alt=""
                        height="90px">
                </a>
            </div>
        </div>
    </nav> -->
    <!-- <main class="container-fluid login-container">
        <div class="container">
            <div class="row pt-5 pt-5">
                <div class="col-lg-6 col-md-8 col-sm-12 login-card m-auto">
                    <h3>Login</h3>
                    <div class="content">
                        <form method="POST" class="login-form" action="{{ route('project.login') }}">
                            @csrf
                            <div class="row">
                                <div class="select-group col-lg-6 col-md-6 col-sm-12">
                                    <div class="group-wrapper">
                                        <img src="{{ url('front_end/assets/imgs/branch-icon.png') }}" alt=""
                                            srcset="">
                                        {!! Form::select('branches[]', $branches, null, [
                                            'data-placeholder' => 'Branch',
                                            'class' => 'js-example-basic-single js-states form-control',
                                            'style' => 'width:100%',
                                            'id' => 'id_branch',
                                        ]) !!}
                                    </div>
                                </div>
                                <div class="select-group col-lg-6 col-md-6 col-sm-12" id="id_project_cont">
                                    <div class="group-wrapper">
                                        <img src="{{ url('front_end/assets/imgs/project-icon.png') }}" alt=""
                                            srcset="">
                                        {!! Form::select('project_id', $projects, null, [
                                            'class' => 'js-example-basic-single js-states form-control',
                                            'style' => 'width:100%',
                                            'id' => 'id_project',
                                            'required' => 'required',
                                            'data-placeholder' => trans('Projects'),
                                        ]) !!}
                                    </div>

                                </div>


                            </div>
                            <div class="row password-row align-items-center">
                                <div class="col-lg-12 password">
                                    <img src="{{ url('front_end/assets/imgs/password-icon.png') }}" alt=""
                                        srcset="">
                                    <input class="form-control @error('password') is-invalid @enderror" type="password"
                                        placeholder="Password" name="password" required autocomplete="current-password"
                                        id="password-input">
                                    <span class="view-password" style="cursor: pointer" id="view">
                                        <i class="fa-solid fa-eye"></i>
                                    </span>
                                    <span class="view-password d-none" style="cursor: pointer" id="un-view">
                                        <i class="fa-solid fa-eye-slash"></i>
                                    </span>

                                </div>
                            </div>
                            @if ($errors->has('message'))
                                <span role="alert">
                                    <strong> {{ $errors->first('message') }}
                                    </strong>
                                </span>
                            @endif
                            <button type="submit" class="btn login-btn d-block">Login</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </main> -->
    <!-- <footer class="container-fluid">
        @php
            $settings = App\Models\Setting::where('id', 1)->first();
            $privacy_policy = App\Models\Page::where('id', $settings->privacy_id)
                ->select('slug')
                ->first();
            $terms_conditions = App\Models\Page::where('id', $settings->terms_id)
                ->select('slug')
                ->first();
        @endphp
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 col-md-6 col-sm-12 links">
                    <a href="{{ route('getPage', $privacy_policy->slug) }}">Privacy Policy</a>
                    <a href="{{ route('getPage', $terms_conditions->slug) }}">Terms and Conditions</a>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-12 social">
                    <a href="{{ $settings->facebook }}" target="blank" class="social-link">
                        <i class="fa-brands fa-facebook-f"></i>
                    </a>
                    <a href="{{ $settings->tweetir }}" target="blank" class="social-link">
                        <i class="fa-brands fa-twitter"></i>
                    </a>
                    <a href="{{ $settings->linkedin }}" target="blank" class="social-link">
                        <i class="fa-brands fa-linkedin-in"></i>
                    </a>
                    <a href="{{ $settings->instegram }}" target="blank" class="social-link">
                        <i class="fa-brands fa-instagram"></i> </a>
                    <a href="{{ $settings->youtube }}" target="blank" class="social-link">
                        <i class="fa-brands fa-youtube"></i> </a>
                </div>
            </div>
        </div>
    </footer> -->

    <div class="login-page">
        <div class="row h-p100">
        <div class="img-part col-md-6 col-lg-8">
                <img src="panel_them/images/login-bg.jpeg" alt="">
            </div>
            <div class="col-md-6 col-lg-4">
                    <div class="logo mb-30 mt-15">
                                <img src="{{ url('front_end/assets/imgs/petrojet-logo.png') }}" alt=""
                        height="90px">
                    </div>
                    <div class="form-part">
                        <h2>
                            Login
                        </h2>
                        <div class="form-wrapper d-flex justify-content-center">
                            <form method="POST" class="login-form" action="{{ route('project.login') }}">
                                @csrf
                                <div class="row">
                                    <div class="select-group col-lg-12 col-md-12 col-sm-12">
                                        <div class="group-wrapper">
                                            <img src="{{ url('front_end/assets/imgs/branch-icon.png') }}" alt=""
                                                srcset="">
                                            {!! Form::select('branches[]', $branches, null, [
                                                'data-placeholder' => 'Branch',
                                                'class' => 'js-example-basic-single js-states form-control',
                                                'style' => 'width:100%',
                                                'id' => 'id_branch',
                                            ]) !!}
                                        </div>
                                    </div>
                                    <div class="select-group col-lg-12 col-md-12 col-sm-12" id="id_project_cont">
                                        <div class="group-wrapper">
                                            <img src="{{ url('front_end/assets/imgs/project-icon.png') }}" alt=""
                                                srcset="">
                                            {!! Form::select('project_id', $projects, null, [
                                                'class' => 'js-example-basic-single js-states form-control',
                                                'style' => 'width:100%',
                                                'id' => 'id_project',
                                                'required' => 'required',
                                                'data-placeholder' => trans('Projects'),
                                            ]) !!}
                                        </div>
                                    </div>
                                </div>
                                <div class="row password-row align-items-center">
                                    <div class="col-lg-12 password">
                                        <img src="{{ url('front_end/assets/imgs/password-icon.png') }}" alt=""
                                            srcset="">
                                        <input class="form-control @error('password') is-invalid @enderror" type="password"
                                            placeholder="Password" name="password" required autocomplete="current-password"
                                            id="password-input">
                                        <span class="view-password" style="cursor: pointer" id="view">
                                            <i class="fa-solid fa-eye"></i>
                                        </span>
                                        <span class="view-password d-none" style="cursor: pointer" id="un-view">
                                            <i class="fa-solid fa-eye-slash"></i>
                                        </span>
                                    </div>
                                </div>
                                @if ($errors->has('message'))
                                    <span role="alert">
                                        <strong> {{ $errors->first('message') }}
                                        </strong>
                                    </span>
                                @endif
                                <button type="submit" class="btn login-btn d-block">Login</button>
                            </form>
                        </div>
                    </div>
                    <footer class="container-fluid">
                        @php
                            $settings = App\Models\Setting::where('id', 1)->first();
                            $privacy_policy = App\Models\Page::where('id', $settings->privacy_id)
                                ->select('slug')
                                ->first();
                            $terms_conditions = App\Models\Page::where('id', $settings->terms_id)
                                ->select('slug')
                                ->first();
                        @endphp
                        <div class="container">
                            <div class="row align-items-center">
                                <div class="col-lg-12 col-md-12 col-sm-12 links text-center">
                                    <a href="{{ route('getPage', $privacy_policy->slug) }}">Privacy Policy</a>
                                    <a href="{{ route('getPage', $terms_conditions->slug) }}">Terms and Conditions</a>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 social text-center">
                                    <a href="{{ $settings->facebook }}" target="blank" class="social-link">
                                        <i class="fa-brands fa-facebook-f"></i>
                                    </a>
                                    <a href="{{ $settings->tweetir }}" target="blank" class="social-link">
                                        <i class="fa-brands fa-twitter"></i>
                                    </a>
                                    <a href="{{ $settings->linkedin }}" target="blank" class="social-link">
                                        <i class="fa-brands fa-linkedin-in"></i>
                                    </a>
                                    <a href="{{ $settings->instegram }}" target="blank" class="social-link">
                                        <i class="fa-brands fa-instagram"></i> </a>
                                    <a href="{{ $settings->youtube }}" target="blank" class="social-link">
                                        <i class="fa-brands fa-youtube"></i> </a>
                                </div>
                            </div>
                        </div>
                    </footer>
            </div>

        </div>
    </div>
    <script src="{{ url('front_end/assets/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ url('front_end/assets/js/jquery.min.js') }}"></script>
    <script src="{{ url('front_end/assets/js/select2.min.js') }}"></script>
    <script type="text/javascript">
        $(document).ready(function() {
            $('#view').on('click', function(event) {
                this.classList.add('d-none')
                $('#un-view').removeClass('d-none')
                $('#password-input').attr('type', 'text')
            })

            $('#un-view').on('click', function(event) {
                this.classList.add('d-none')
                $('#view').removeClass('d-none')
                $('#password-input').attr('type', 'password')
            })
            $("#id_project").select2({
                closeOnSelect: true,
                placeholder: {
                    id: '-1', // the value of the option
                    text: 'Project'
                }
            });
            $("#id_branch").select2({
                closeOnSelect: true,
                placeholder: {
                    id: '-1', // the value of the option
                    text: 'Branch'
                }
            }).on("select2:select", function(e) {
                var branch = $(this).val();
                $.post('{{ route('frontProject.getProjectsByBranch') }}', {
                    _token: '{{ csrf_token() }}',
                    branch_id: branch
                }, function(data) {
                    $('#id_project_cont').html(data);
                });
            })
        })
    </script>
</body>

</html>
