@extends('admin.layouts.main')
@section('content')
    <style>
        .dropdown-menu {
            padding: 2px;
        }

        .dropdown-menu label {
            display: flex;
            align-items: center;
            margin-bottom: 1px;
            padding: 5px;
            border-radius: 4px;
        }

        .selected-label {
            background-color: #d1ecf1;
        }
    </style>
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title"> {{ trans('messages.Sended Forms') }}</h3>
            </div>

        </div>
    </div>
    <section class="content">
        <div class="box">

            <div class="box-header">
                <p>
                    <button class="btn btn-primary" type="button" data-toggle="collapse" data-target="#collapseExample" aria-expanded="false" aria-controls="collapseExample">
                        Filters
                    </button>
                </p>
                <div class="collapse" id="collapseExample">
                    <div class="card card-body">
                        <form action="{{ route('projectForm.index') }}" method="GET">
                            <div class="row">
                                <div class="col-12 mb-3">
                                    <div class="row">
                                        <div class="col-2">
                                            <div class="app-menu">
                                                <div class="search-bx mx-5">
                                                    <div class="input-group">
                                                        <input type="search" id="search" class="form-control" name="search"
                                                               @isset($sort_search) value="{{ $sort_search }}" @endisset
                                                               placeholder="{{ trans('messages.Name') }}" aria-label="Search"
                                                               aria-describedby="button-addon2">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-2">
                                            <div class="app-menu">
                                                <div class="search-bx mx-5">
                                                    <div class="input-group">
                                                        <input type="search" id="search" class="form-control" name="user_name"
                                                               @isset($user_name) value="{{ $user_name }}" @endisset
                                                               placeholder="{{ trans('messages.user_name') }}"
                                                               aria-label="Search"
                                                               aria-describedby="button-addon2">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-2">
                                            <div class="app-menu">
                                                <div class="search-bx mx-5">
                                                    <div class="input-group">
                                                        <input type="search" id="search" class="form-control"
                                                               name="email_branch"
                                                               @isset($email_branch) value="{{ $email_branch }}" @endisset
                                                               placeholder="{{ trans('messages.email_branch') }}"
                                                               aria-label="Search"
                                                               aria-describedby="button-addon2">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-2">
                                            <div class="app-menu">
                                                <div class="search-bx mx-5">
                                                    <div class="input-group">
                                                        <input type="search" id="search" class="form-control"
                                                               name="phone_branch"
                                                               @isset($phone_branch) value="{{ $phone_branch }}" @endisset
                                                               placeholder="{{ trans('messages.phone_branch') }}"
                                                               aria-label="Search"
                                                               aria-describedby="button-addon2">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-2">
                                            <div class="app-menu">
                                                <div class="search-bx mx-5">
                                                    <div class="input-group">
                                                        <input type="search" id="search" class="form-control"
                                                               name="project_name"
                                                               @isset($project_name) value="{{ $project_name }}" @endisset
                                                               placeholder="{{ trans('messages.Hse Manager Name') }}"
                                                               aria-label="Search"
                                                               aria-describedby="button-addon2">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-2">
                                            <div class="app-menu">
                                                <div class="search-bx mx-5">
                                                    <div class="input-group">
                                                        <input type="search" id="search" class="form-control"
                                                               name="email_project"
                                                               @isset($email_project) value="{{ $email_project }}" @endisset
                                                               placeholder="{{ trans('messages.email_project') }}"
                                                               aria-label="Search"
                                                               aria-describedby="button-addon2">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="row">
                                        <div class="col-2">
                                            <div class="app-menu">
                                                <div class="search-bx mx-5">
                                                    <div class="input-group">
                                                        <input type="search" id="search" class="form-control"
                                                               name="phone_project"
                                                               @isset($phone_project) value="{{ $phone_project }}" @endisset
                                                               placeholder="{{ trans('messages.phone_project') }}"
                                                               aria-label="Search"
                                                               aria-describedby="button-addon2">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-2">
                                            <select name="status" id="status-filter" class="form-control">
                                                <option value="all">{{ trans('messages.All Status') }}</option>
                                                <option {{ $status == 'waiting' ? 'selected' : '' }} value="waiting">
                                                    {{ trans('messages.Waiting') }}</option>
                                                <option {{ $status == 'incomplete' ? 'selected' : '' }} value="incomplete">
                                                    {{ trans('messages.Incomplete') }}</option>
                                                <option {{ $status == 'expired' ? 'selected' : '' }} value="expired">
                                                    {{ trans('messages.Expired') }}</option>
                                                <option {{ $status == 'approved' ? 'selected' : '' }} value="approved">
                                                    {{ trans('messages.Approved') }}</option>
                                                <option
                                                    {{ $status == 'waiting approved' ? 'selected' : '' }} value="waiting approved">
                                                    {{ trans('messages.waiting approved') }}</option>
                                                <option {{ $status == 'done' ? 'selected' : '' }} value="done">
                                                    {{ trans('messages.Done') }}</option>
                                            </select>
                                        </div>
                                        <div class="col-2">
                                            <select name="branch_id" id="branch-filter" class="select2 form-control">
                                                <option value="0">{{ trans('messages.All Branches') }}</option>
                                                @foreach ($branches as $branche)
                                                    <option
                                                        {{ $branch_id == $branche->id ? 'selected' : '' }} value="{{ $branche->id }}">
                                                        {{ $branche->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-2" id="projects-container">

                                        </div>
                                        <div class="col-2">
                                            <div class="form-group">
                                                <div>
                                                    {!! Form::select('form_id', $originalForms, $form_id, [
                                                        'class' => 'form-control select2',
                                                        'style' => 'width:100%',
                                                        'id' => 'form_id',
                                                        'data-placeholder' => trans('messages.Forms'),
                                                    ]) !!}
                                                </div>
                                            </div>

                                        </div>
                                        <input type="hidden" name="limit" value="{{request()->get('limit', 15)}}">


                                        <div class="col-2" style="position: relative">
                                            <i class="fa fa-filter"
                                               style="position: absolute;{{ App::getLocale() == 'ar' ? 'right' : 'left' }}:1em;font-size: 1.5em;line-height: 1.5em;color: #FFF"></i>
                                            <input style="height: 2em;line-height: 1em;padding: 0em 2em" type="submit"
                                                   value="{{ trans('messages.Filter') }}" class="btn btn-primary">
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="box-body">
                <div class="row">
                    <div class="col-12 mb-10">
                        <div class="row justify-content-between">
                            <div class="col-2 mt-5">
                                <div class="dropdown">
                                    <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton"
                                            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                       {{trans('messages.show/hide columns')}}
                                    </button>
                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                        <ul class="list-unstyled">
                                            <li><a class="toggle-vis" data-column="0"># - num</a>
                                            </li>
                                            <li><a class="toggle-vis" data-column="1">{{ trans('messages.Form Name') }}</a>
                                            </li>
                                            <li><a class="toggle-vis" data-column="2">{{ trans('messages.Branch') }}</a>
                                            </li>
                                            <li><a class="toggle-vis" data-column="3">{{ trans('messages.user_name') }}</a>
                                            </li>

                                            <li><a class="toggle-vis"
                                                   data-column="4">{{ trans('messages.phone_branch') }}</a>
                                            </li>
                                            <li><a class="toggle-vis" data-column="5">{{ trans('messages.Project') }}</a>
                                            </li>
                                            <li><a class="toggle-vis"
                                                   data-column="6">{{ trans('messages.Hse Manager Name') }}</a></li>
                                            <li><a class="toggle-vis" data-column="7">{{ trans('messages.phone_project') }}</a></li>
                                            <li><a class="toggle-vis" data-column="8">{{ trans('messages.Status') }}</a>
                                            </li>
                                            <li><a class="toggle-vis"
                                                   data-column="9">{{ trans('messages.Expiration') }}</a>
                                            </li>
                                            <li><a class="toggle-vis" data-column="10">{{ trans('messages.Created') }}</a>
                                            </li>
                                            <li><a class="toggle-vis" data-column="11">{{ trans('messages.Options') }}</a>
                                            </li>

                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-2 mt-5">
                                <select class="form-control" id="selected_limit">
                                    <option {{request()->get('limit', 15) == 15 ?'selected' : ''}} value="15">15
                                    </option>
                                    <option {{request()->get('limit', 15) == 50 ?'selected' : ''}} value="50">50
                                    </option>
                                    <option {{request()->get('limit', 15) == 100 ?'selected' : ''}} value="100">100
                                    </option>
                                    <option {{request()->get('limit', 15) == 1000 ?'selected' : ''}} value="1000">
                                        1000
                                    </option>
                                    <option {{request()->get('limit', 15) == 1500 ?'selected' : ''}} value="2000">
                                        1500
                                    </option>
                                </select>
                            </div>
                        </div>

                    </div>
                    <div class="col-12">
                        <div class="table-responsive" style=" overflow: hidden !important;">
                            <table id="example" class="table table-hover">
                                <thead>
                                <tr class="">
                                    <th class="text-center">
                                        #
                                    </th>
                                    <th class="text-center">{{ trans('messages.Form Name') }}</th>
                                    <th class="text-center">{{ trans('messages.Branch') }}</th>
                                    <th class="text-center">{{ trans('messages.user_name') }}</th>
                                    <th class="text-center">{{ trans('messages.phone_branch') }}</th>
                                    <th class="text-center">{{ trans('messages.Project') }}</th>
                                    <th class="text-center">{{ trans('messages.Hse Manager Name') }}</th>
                                    <th class="text-center">{{ trans('messages.phone_project') }}</th>
                                    <th class="text-center">{{ trans('messages.Status') }}</th>
                                    <th class="text-center">{{ trans('messages.Expiration') }}</th>
                                    <th class="text-center">{{ trans('messages.Created') }}</th>
                                    <th class="text-center">{{ trans('messages.Options') }}</th>
                                </tr>
                                </thead>
                                <tbody>
                                @php
                                    $bills = [
                                        'waiting' => 'badge-info-light',
                                        'incomplete' => 'badge-primary-light',
                                        'expired' => 'badge-danger-light',
                                        'done' => 'badge-warning-light',
                                        'approved'=>'badge-warning-light',
                                        'rejected'=>'badge-danger-light',
                                        'waiting approved'=>'badge-danger-light'
                                    ];
                                @endphp
                                @foreach ($forms as $key => $form)
                                    <tr>
                                        <td class="text-center">
                                            {{ $key + 1 + ($forms->currentPage() - 1) * $forms->perPage() }}
                                        </td>
                                        <td class="text-center">{{ $form->form->name }}</td>
                                        <td class="text-center">{{ $form->project->branch->name }}</td>
                                        <td class="text-center">{{ $form->project->branch->user_name }}</td>
                                        <td class="text-center">{{ $form->project->branch->phone }}</td>
                                        <td class="text-center">{{ $form->project->name }}</td>
                                        <td class="text-center">{{ $form->project->hse_manager_name }}</td>
                                        <td class="text-center">{{ $form->project->phone }}</td>
                                        <td class="text-center">
                                            <div
                                                class="badge badge-pill {{ $bills[$form->status] }}">{{ $form->status }}
                                            </div>
                                        </td>
                                        <td class="text-center">{{ $form->expiration_date }}</td>
                                        <td class="text-center">{{ $form->created_at }}</td>
                                        <td class="text-center">
                                            <a href="{{ route('projectForm.show', $form->id) }}"
                                               class="waves-effect waves-light btn btn-primary-light btn-circle mx-5"><span
                                                    class="mdi mdi-magnify"><span class="path1"></span><span
                                                        class="path2"></span></span></a>
                                            <a href="{{ route('form.pdfDownload', $form->id) }}"
                                               class="waves-effect waves-light btn btn-primary-light btn-circle mx-5"><span
                                                    class="mdi mdi-file-pdf"><span class="path1"></span><span
                                                        class="path2"></span></span></a>
                                            <a   onclick="return confirm('Are you sure?')"  href="{{ route('form.admin.del', $form->id) }}"
                                                 class="waves-effect waves-light btn btn-primary-light btn-circle mx-5"><span
                                                    class="mdi mdi-beer"><span class="path1"></span><span
                                                        class="path2"></span></span></a>
                                        </td>
                                    </tr>
                                @endforeach

                                </tbody>
                            </table>
                            {!! $forms->withQueryString()->links('pagination::bootstrap-4') ?? '' !!}

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>
@endsection
@section('modal')
    <div class="modal modal-left fade" id="modal-left" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content" id="view-company">

            </div>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript">
        $(document).ready(function () {
            $('.select2').select2();
            var branch_id = $('#branch-filter').val();
            $.post(`{{ route('project.getProjectsByBranchId') }}`, {
                _token: '{{ csrf_token() }}',
                branch_id: branch_id,
                project_id: {{ $project_id ? $project_id : 0 }},
            }, function (data) {
                $('#projects-container').html(data)
            });

            $('#branch-filter').change(function () {
                var branch_id = $(this).val();
                $.post(`{{ route('project.getProjectsByBranchId') }}`, {
                    _token: '{{ csrf_token() }}',
                    branch_id: branch_id,
                    project_id: {{ $project_id ? $project_id : 0 }},
                }, function (data) {
                    $('#projects-container').html(data)
                });
            })
        })
    </script>
    <script type="text/javascript">
        var table = $('#example').DataTable({
            paging: false,
            dom: 'Bfrtip',
            template: "orange_medium", // Apply the "green_medium" template
            scrollX: true,
            autoWidth: false,
            buttons: [{
                extend: "excel",
                exportOptions: {
                    columns: ':visible' // Ensure all visible columns are exported
                },
                excelStyles: [ // Add an excelStyles definition
                    {
                        template: "orange_medium", // Apply the "green_medium" template
                    },
                    {
                        cells: "sh", // Use Smart References (s) to target the header row (h)
                        style: { // The style definition
                            font: { // Style the font
                                size: 14, // Size 14
                                b: false, // Turn off the default bolding of the header row
                            },
                            fill: { // Style the cell fill
                                pattern: { // Add a pattern (default is solid)
                                    color: "cc0000" // Define the fill color
                                }
                            }
                        }
                    }
                ],
                customize: function (xlsx) {
                    var sheet = xlsx.xl.worksheets['sheet1.xml'];
                    // Include hidden columns in the export
                    $('row c[r^="A"]', sheet).attr('s', '25');
                }
            }, 'print']
        });
        document.querySelectorAll('a.toggle-vis').forEach((el) => {
            el.addEventListener('click', function (e) {
                e.preventDefault();

                let columnIdx = e.target.getAttribute('data-column');
                let column = table.column(columnIdx);
                let parentLi = e.target.closest('li');

                // Toggle the visibility
                column.visible(!column.visible());
                parentLi.classList.toggle('selected-label');
            });

        });
        $('#selected_limit').on('change', function () {
            var pageLength = $(this).val();
            // Update DataTable page length
            table.page.len(pageLength).draw();

            // Get the current URL parameters
            var params = new URLSearchParams(window.location.search);

            // Set the new length parameter
            params.set('limit', pageLength);

            // Reload the page with the new parameters
            window.location.search = params.toString();
        });
    </script>

@endsection
