@extends('admin.layouts.main')
@section('content')
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title">Activitylog </h3>
            </div>

        </div>
    </div>
    <!-- Main content -->
    <section class="content">
        <div class="box">
            <div class="box-header">
                <form action="{{ route('log.search') }}" method="GET">
                <div class="row">
                    <div class="col-4">
                        <div class="app-menu">
                            <div class="search-bx mx-5">
                                    <div class="input-group">
                                        <select name="name" class="form-control">
                                            <option value="branch" {{app('request')->input('name') == "branch" ? 'selected':'' }}>{{__('messages.Branches')}}</option>
                                            <option value="users" {{app('request')->input('name') == "users" ? 'selected':'' }}>{{__('messages.Moderators')}}</option>
                                            <option value="form" {{app('request')->input('name') == "form" ? 'selected':'' }}>{{__('messages.Form Builder')}}</option>
                                            <option value="fixed" {{app('request')->input('name') == "fixed" ? 'selected':'' }}>{{__('messages.Forms fixed')}}</option>
                                            <option value="setting" {{app('request')->input('name') == "setting" ? 'selected':'' }}>{{__('messages.setttings')}}</option>
                                            <option value="projectForm" {{app('request')->input('name') == "projectForm" ? 'selected':'' }}>{{__('messages.Sended Forms')}}</option>
                                            <option value="projectFixed" {{app('request')->input('name') == "projectFixed" ? 'selected':'' }}>{{__('messages.Form fixed send')}}</option>
                                            <option value="projects" {{app('request')->input('name') == "projects" ? 'selected':'' }}>{{__('messages.Projects')}}</option>
                                            <option value="Page" {{app('request')->input('name') == "Page" ? 'selected':'' }}>{{__('messages.Static Pages')}}</option>
                                            <option value="notification" {{app('request')->input('name') == "notification" ? 'selected':'' }}>{{__('messages.notificationbar')}}</option>
                                        </select>
                                    </div>

                            </div>
                        </div>
                    </div>
                    <div class="col-3">
                        <button type="submit"
                                class="waves-effect waves-light btn btn-primary-light"><span
                                class="mdi mdi-search-web"><span class="path1"></span><span class="path2"></span></span></button>

                    </div>
                </div>
                </form>



            </div>
            <div class="box-body no-padding">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                        <tr class="bg-dark">
                            <th>#</th>
                            <th>{{__('messages.created_by')}} </th>
                            <th>{{__('messages.title or name')}}</th>
                            <th>{{__('messages.event')}}</th>
                            <th>{{__('messages.created_at')}}</th>
                            <th>{{__('messages.show')}}</th>
                        </tr>
                        </thead>
                        <tbody>
                        @if(!empty($activity))
                            @foreach($activity as $arc)
                                <tr class="bg-table-gray changnametr">
                                    <td>{{$loop->iteration}}</td>
                                    <td>{{$arc->causer->name ?? ''  }}
                                        @if($arc->causer_type == "projects")
                                            {{' - '.$arc->causer->hse_manager_name}}
                                        @elseif($arc->causer_type == "branch")

                                        @endif
                                    </td>
                                    @if(in_array($inlog,["projectForm","projectFixed"]))
                                    <td>{{$arc->subject->form ? $arc->subject->form->name : '' }}</td>
                                    @elseif($inlog == "notification")
                                        <td>{{$arc->subject->text ?? '' }}</td>
                                    @elseif($inlog == "Page")
                                        <td>{{$arc->subject->title ?? '' }}</td>
                                    @else
                                        <td>{{$arc->subject->name ?? '' }}</td>
                                    @endif
                                    <td>{{$arc->description}}</td>
                                    <td>{{$arc->created_at}}</td>
                                    <td>
                                        <div class="btn-group">
                                            <button type="button"
                                                    class="waves-effect waves-light btn btn-secondary dropdown-toggle"
                                                    data-toggle="dropdown" aria-expanded="false">
                                            </button>
                                            <div class="dropdown-menu" style="">
                                                <a class="dropdown-item"
                                                   href="{{route('log.show',[$arc->id,$inlog])}}">{{__('messages.show')}}</a>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        @endif

                        </tbody>
                    </table>
                    @if($activity != null)
                        {!! $activity->withQueryString()->links('pagination::bootstrap-4') ?? '' !!}
                    @endif
                </div>
            </div>
        </div>
    </section>
@endsection
@section('modal')
    <div class="modal modal-left fade" id="modal-left" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content" id="view-company">

            </div>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript"></script>
@endsection
