@extends('admin.layouts.main')
@section('content')
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title"> {{ trans('messages.Show Form') }}</h3>
            </div>

        </div>
    </div>
    <style>
        #gallery-content-center img {
            width: 70px;
        }

        .header-content {
            background: #C4161C;
            color: white;
            display: flex;
            justify-content: space-between;
            padding: 15px 20px;
            border-radius: 8px;
        }
    </style>
    <section class="content">
        <div class="row">
            <div class="col-lg-12 mx-auto">
                <div class="box">
                    <div class="box-body">
                        <h3>{{ trans('messages.Branch') }}</h3>
                        <table class="table table-hover">
                            <thead>
                            <tr class="">
                                <th class="text-center">{{ trans('messages.Name') }}</th>
                                <th class="text-center">{{ trans('messages.user_name') }}</th>
                                <th class="text-center">{{ trans('messages.Email') }}</th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr>
                                <td class="text-center">{{ $projectForm->branch->name }}</td>
                                <td class="text-center">{{ $projectForm->branch->name }}</td>
                                <td class="text-center">{{$projectForm->branch->email }}</td>
                            </tr>
                            </tbody>
                        </table>

                    </div>
                </div>
            </div>
            <div class="col-lg-12 mx-auto">
                <div class="box">
                    <div class="box-body">
                        <h3>{{ trans('messages.Project') }}</h3>
                        <table class="table table-hover">
                            <thead>
                            <tr class="">
                                <th class="text-center">{{ trans('messages.Project') }}</th>
                                <th class="text-center">{{ trans('messages.Hse Manager Name') }}</th>
                                <th class="text-center">{{ trans('messages.Email') }}</th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr>
                                <td class="text-center">{{ $projectForm->project->name }}</td>
                                <td class="text-center">{{ $projectForm->project->hse_manager_name }}</td>
                                <td class="text-center">{{$projectForm->project->email }}</td>
                            </tr>
                            </tbody>
                        </table>

                    </div>
                </div>
            </div>

            <div class="col-lg-8 mx-auto">
                <div class="box">
                    <div class="box-body">
                        <div class="row pt-5 pt-5">
                            <div class="col-lg-10 col-md-10 col-sm-12 view-card m-auto">
                                <h3 class="text-center">{{ $projectForm->form->name }}</h3>
                                @php
                                    $bills = [
                                  'waiting' => 'badge-info-light',
                                'open' => 'badge-info-light',
                                'incomplete' => 'badge-primary-light',
                                'expired' => 'badge-danger-light',
                                'done' => 'badge-warning-light',
                                'approved'=>'badge-warning-light',
                                'rejected'=>'badge-danger-light'
                                    ];
                                @endphp
                                <div class="content">
                                    <div class=header-content>
                                        <h5 class="created-date">
                                            <span>Created at: </span>
                                            {{ date('Y-m-d', strtotime($projectForm->created_at)) }}
                                        </h5>
                                        <h5 class="expiration-date">
                                            <span>updated date: </span>
                                            {{ date('Y-m-d', strtotime($projectForm->updated_at)) }}
                                        </h5>
                                        <div class="badge badge-pill {{ $bills[$projectForm->status]??'' }}">
                                            {{ $projectForm->status }}</div>
                                    </div>
                                    <br>
                                    <div class="form-content">
                                        <div class="d-flex justify-content-between">
                                            <div class="attached-title d-flex justify-content-center">
                                                <h5>
                                                    Attached Files
                                                </h5>
                                            </div>
                                        </div>
                                        <div class="attached-data">
                                            <div id="gallery-content">
                                                <div id="gallery-content-center">
                                                    @foreach ($projectForm->form->formFiles as $file)
                                                        @switch($file->type)
                                                            @case('image/png')
                                                                <a href="{{ url($file->file_path) }}"
                                                                   data-toggle="lightbox"
                                                                   data-gallery="multiimages"
                                                                   data-title="Show Form Files"><img
                                                                        src="{{ url($file->file_path) }}" alt="gallery"
                                                                        class="all studio"/> </a>
                                                                @break

                                                            @case('image/jpg')
                                                                <a href="{{ url($file->file_path) }}"
                                                                   data-toggle="lightbox"
                                                                   data-gallery="multiimages"
                                                                   data-title="Show Form Files"><img
                                                                        src="{{ url($file->file_path) }}" alt="gallery"
                                                                        class="all studio"/> </a>
                                                                @break

                                                            @case('image/jpeg')
                                                                <a href="{{ url($file->file_path) }}"
                                                                   data-toggle="lightbox"
                                                                   data-gallery="multiimages"
                                                                   data-title="Show Form Files"><img
                                                                        src="{{ url($file->file_path) }}" alt="gallery"
                                                                        class="all studio"/> </a>
                                                                @break

                                                            @case('application/pdf')
                                                                <a href="{{ url($file->file_path) }}" data-fancybox
                                                                   data-type="iframe">
                                                                    <img
                                                                        src="{{ url('front_end/assets/imgs/file-icon.png') }}"
                                                                        alt="">
                                                                </a>
                                                                @break

                                                            @default
                                                        @endswitch
                                                    @endforeach
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @foreach ($formInputs as $key => $input)
                                        @switch($input->input_type)
                                            @case('text')
                                                <div class="form-group mb-3">
                                                    <label for="text-input"
                                                           class="form-label">{{ $input->formInput->label }}</label>
                                                    <input name="inputs[{{ $input->id }}][answer]" type="text"
                                                           id="text-input{{ $key }}" value="{{ $input->answer }}"
                                                           class="form-control" disabled>
                                                </div>
                                                @break

                                            @case('number')
                                                <div class="form-group mb-3">
                                                    <label for="number-input"
                                                           class="form-label">{{ $input->formInput->label }}</label>
                                                    <input type="number" value="{{ $input->answer }}" disabled
                                                           id="number-input{{ $key }}" class="form-control"
                                                           name="inputs[{{ $input->id }}][answer]">
                                                </div>
                                                @break

                                            @case('textarea')
                                                <div class="form-group mb-3">
                                                    <label for="textarea-input"
                                                           class="form-label">{{ $input->formInput->label }}</label>
                                                    <textarea disabled class="form-control resize-none"
                                                              name="inputs[{{ $input->id }}][answer]"
                                                              id="textarea-input{{ $key }}"
                                                              rows="3">{{ $input->answer }}</textarea>
                                                    <input type="hidden" name="inputs[{{ $input->id }}][type]"
                                                           value="{{ $input->input_type }}">
                                                </div>
                                                @break

                                            @case('file')
                                                <div class="form-group mb-3 custom-file">
                                                    <label for="number-input"
                                                           class="form-label">{{ $input->formInput->label }}</label>
                                                    <br>
                                                    @if ($input->answer)
                                                        <div style="margin-bottom: 2em;height: 5em">
                                                            @if ($input->file_type == 'application/pdf')
                                                                <a id="old-pdf-file" href="{{ url($input->answer) }}"
                                                                   data-fancybox
                                                                   data-type="iframe">
                                                                    <img
                                                                        src="{{ url('front_end/assets/imgs/file-icon.png') }}"
                                                                        alt="">
                                                                </a>
                                                            @else
                                                                <a href="{{ url($input->answer) }}"
                                                                   data-fancybox="gallery">
                                                                    <img class="old-img" width="60px"
                                                                         src="{{ url($input->answer) }}" alt="">
                                                                </a>
                                                            @endif
                                                        </div>
                                                    @endif
                                                </div>
                                                <br>
                                                <br>
                                                @break
                                            @case('checkbox')
                                                <div class="form-group col-xl-12 col-sm-12 mb-3">
                                                    <label for="textarea-input"
                                                           class="form-label">{{ $input->formInput->label }}</label>
                                                    @if($input->formInput->inputsElemnts != null)
                                                        @foreach($input->formInput->inputsElemnts as $el)
                                                            <div class="checkbox-group">
                                                                <input type="checkbox" id="{{$el->name }}"
                                                                       name="inputs[{{ $input->id }}][answer][]"
                                                                       class="filled-in chk-col-danger checkbox-input"
                                                                       value="{{$el->id}}" disabled
                                                                @if($input->answer != null)
                                                                    {{in_array($el->id,json_decode($input->answer,true)) ?'checked':''}}
                                                                    @endif

                                                                />
                                                                <label for="{{$el->name}}"
                                                                       class="form-label checkbox-label">{{ $el->name }}</label>
                                                                <input type="hidden"
                                                                       name="inputs[{{ $input->id }}][type]"
                                                                       value="{{ $input->input_type }}">

                                                            </div>

                                                        @endforeach
                                                    @endif

                                                </div>
                                                @break
                                            @case('radio')
                                                <div class="form-group col-xl-12 col-sm-12 mb-3">
                                                    <label for="textarea-input"
                                                           class="form-label">{{ $input->formInput->label }}</label>
                                                    @if($input->formInput->inputsElemnts != null)
                                                        @foreach($input->formInput->inputsElemnts as $el)
                                                            <div class="checkbox-group">
                                                                <input type="radio" id="{{$el->name }}"
                                                                       name="inputs[{{ $input->id }}][answer]"
                                                                       class="filled-in chk-col-danger checkbox-input"
                                                                       value="{{$el->id}}"
                                                                       {{ $el->id == $input->answer ?'checked':''}}
                                                                       disabled
                                                                />
                                                                <label for="{{$el->name}}"
                                                                       class="form-label checkbox-label">{{ $el->name }}</label>
                                                                <input type="hidden"
                                                                       name="inputs[{{ $input->id }}][type]"
                                                                       value="{{ $input->input_type }}">

                                                            </div>

                                                        @endforeach
                                                    @endif

                                                </div>
                                                @break

                                            @default
                                        @endswitch
                                    @endforeach

                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('modal')
    <div class="modal modal-left fade" id="modal-left" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content" id="view-company">

            </div>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript">
        // delegate calls to data-toggle="lightbox"
        $(document).delegate('*[data-toggle="lightbox"]:not([data-gallery="navigateTo"])', 'click', function (event) {
            event.preventDefault();
            return $(this).ekkoLightbox({
                onShown: function () {
                    if (window.console) {
                        return console.log('Checking our the events huh?');
                    }
                },
                onNavigate: function (direction, itemIndex) {
                    if (window.console) {
                        return console.log('Navigating ' + direction + '. Current item: ' + itemIndex);
                    }
                }
            });
        });
        //Programatically call
        $('#open-image').click(function (e) {
            e.preventDefault();
            $(this).ekkoLightbox();
        });
        $('#open-youtube').click(function (e) {
            e.preventDefault();
            $(this).ekkoLightbox();
        });
        // navigateTo
        $(document).delegate('*[data-gallery="navigateTo"]', 'click', function (event) {
            event.preventDefault();
            var lb;
            return $(this).ekkoLightbox({
                onShown: function () {
                    lb = this;
                    $(lb.modal_content).on('click', '.modal-footer a', function (e) {
                        e.preventDefault();
                        lb.navigateTo(2);
                    });
                }
            });
        });
    </script>
@endsection
