@extends('admin.layouts.main')
@section('content')
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title">{{ trans('messages.Update Static Page') }}</h3>
            </div>

        </div>
    </div>

    <style>
        .bootstrap-tagsinput {
            width: 100%;
            padding: 0.6em;
        }
    </style>
    <!-- Main content -->

    <section class="content">
        {!! Form::open([
            'method' => 'PUT',
            'route' => ['page.update', $page->id],
            'files' => true,
            'id' => 'edit-pade-form',
        ]) !!}
        <div class="row">
            <div class="col-lg-8 mx-auto">

                <div class="box">
                    <div class="box-body">
                        <div class="form-group">
                            <label for="title">{{ trans('messages.Title') }}
                            </label>
                            <div>
                                {!! Form::text('title', $page->title, [
                                    'onkeyup' => 'makeSlug(this.value)',
                                    'id' => 'title',
                                    'class' => 'form-control',
                                    'placeholder' => trans('messages.Tilte'),
                                ]) !!}
                            </div>
                            @error('title')
                                <div class="badge badge-danger text-center" style="width: 100%">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="slug">{{ trans('messages.Slug') }}
                            </label>
                            <div>
                                {!! Form::text('slug', $page->slug, [
                                    'id' => 'slug',
                                    'required' => 'required',
                                    'class' => 'form-control',
                                    'placeholder' => trans('messages.Slug'),
                                ]) !!}
                            </div>
                            @error('slug')
                                <div class="badge badge-danger text-center" style="width: 100%">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="body">{{ trans('messages.Body') }}
                            </label>
                            <div>
                                {!! Form::textarea('body', $page->body, [
                                    'id' => 'editor1',
                                    'class' => 'form-control',
                                    'placeholder' => trans('messages.Body'),
                                ]) !!}
                            </div>
                            @error('body')
                                <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="checkbox">
                            {!! Form::checkbox('enabel', null, $page->enabel, ['id' => 'Checkbox_1']) !!}
                            <label for="Checkbox_1">{{ trans('messages.Enable Page') }}</label>
                        </div>
                    </div>
                </div>
                <!-- /.box-body -->
                <div class="box-footer">
                    <button type="submit" class="btn btn-rounded btn-primary btn-outline">
                        <i class="ti-save-alt"></i> {{ trans('messages.Save') }}
                    </button>
                </div>
            </div>
        </div>
        </div>
        {!! Form::Close() !!}
    </section>
@endsection


@section('script')
    <script type="text/javascript">
        $('.select2').select2();
        CKEDITOR.replace('editor1')
        $(document).ready(function() {
            $(window).keydown(function(event) {
                if (event.keyCode == 13) {
                    event.preventDefault();
                    return false;
                }
            });
        });

        function makeSlug(val) {
            let str = val;
            let output = str.replace(/\s+/g, '-').toLowerCase();
            $('#slug').val(output);
        }
    </script>
@endsection
