<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\Models\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class ProjectFormInput extends Model
{
    use HasFactory,LogsActivity;
    protected $fillable = [
        'answer',
        'file_type',
        'input_type',
        'calculated',
    ];

    protected static $logName = 'ProjectFormInput';
    protected static $ignoredAttributes = ['created_at', 'updated_at'];
    protected static $logAttributes = ['*'];

    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->description =$eventName;
        $properties = $activity->properties->toArray();
        if (auth()->check()) {
            $causer = auth()->user();
            $gaurd = 'users';
        } elseif (auth('project')->check()) {
            $causer = auth('project')->user();
            $gaurd = 'projects';
        } elseif (auth('branches')->check()) {
            $causer = auth('branches')->user();
            $gaurd = 'branch';
        }
        if ($causer) {
            $activity->causer_type = $gaurd; // Type of the user (e.g., Admin, Project, Branch)
            $activity->causer_id = $causer->id; // ID of the user
        }
        $properties['attributes'] = $this->attributesToArray();
        $properties['old'] = $this->getOriginal();

        $activity->from_id = $this->project_form_id;
        $activity->properties = $properties;
    }

    public function projectForm()
    {
        return $this->belongsTo(ProjectForm::class);
    }

    public function formInput()
    {
        return $this->belongsTo(FormInput::class)->with('inputsElemnts');
    }
}
