<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\Models\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class ProjectFixedInput extends Model
{
    use LogsActivity;
  protected $table = 'project_fixed_inputs';

    protected static $logName = 'ProjectFixedInput';
    protected static $ignoredAttributes = ['created_at', 'updated_at'];
    protected static $logAttributes = ['*'];

    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->description =$eventName;
        $properties = $activity->properties->toArray();
        if (auth()->check()) {
            $causer = auth()->user();
            $gaurd = 'users';
        } elseif (auth('project')->check()) {
            $causer = auth('project')->user();
            $gaurd = 'projects';
        } elseif (auth('branches')->check()) {
            $causer = auth('branches')->user();
            $gaurd = 'branch';
        }
        if ($causer) {
            $activity->causer_type = $gaurd; // Type of the user (e.g., Admin, Project, Branch)
            $activity->causer_id = $causer->id; // ID of the user
        }
        $properties['attributes'] = $this->attributesToArray();
        $properties['old'] = $this->getOriginal();

        $activity->from_id = $this->project_fixed_id;
        $activity->properties = $properties;
    }

    public function projectForm()
    {
        return $this->belongsTo(ProjectFixed::class,'form_id');
    }
    public function formInput()
    {
        return $this->belongsTo(FromFixedInputs::class,'fixed_input_id')->with('inputsElemnts');
    }
}
