<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Models\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class ProjectFixed extends Model
{

    use SoftDeletes,LogsActivity;
    protected $table = 'project_fixed';

    public $incrementing = true;
    protected static $logName = 'projectFixed';
    protected static $logAttributes = ['*'];
    protected static $ignoredAttributes = ['created_at', 'updated_at'];

    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->description =$eventName;
        $properties = $activity->properties->toArray();
        if (auth()->check()) {
            $causer = auth()->user();
            $gaurd = 'users';
        } elseif (auth('project')->check()) {
            $causer = auth('project')->user();
            $gaurd = 'projects';
        } elseif (auth('branches')->check()) {
            $causer = auth('branches')->user();
            $gaurd = 'branch';
        }
        if ($causer) {
            $activity->causer_type = $gaurd; // Type of the user (e.g., Admin, Project, Branch)
            $activity->causer_id = $causer->id; // ID of the user
        }

        $activity->properties = $properties;
    }
    protected static $logOnlyDirty = true;
    public function Form()
    {
        return $this->belongsTo(FormFixed::class,'form_id');
    }

    public function Project()
    {
        return $this->belongsTo(Project::class,'project_id');
    }

    public function Branch()
    {
        return $this->belongsTo(Branch::class,'branch_id');
    }

    public function projectFormInputs()
    {
        return $this->hasMany(ProjectFixedInput::class,'project_fixed_id');
    }
}
