<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\Models\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class FormInput extends Model
{
    use HasFactory, LogsActivity;
    protected $fillable = [
        'label',
        'input_type',
        'calculated',
    ];

    protected static $logName = 'fromInput';
    protected static $ignoredAttributes = ['created_at', 'updated_at'];
    protected static $logAttributes = ['*'];

    public function form()
    {
        return $this->belongsTo(Form::class);
    }

    public function projectFormInputs()
    {
        return $this->hasMany(ProjectFormInput::class);
    }

    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->description =$eventName;
        $properties = $activity->properties->toArray();
        if (auth()->check()) {
            $causer = auth()->user();
            $gaurd = 'users';
        } elseif (auth('project')->check()) {
            $causer = auth('project')->user();
            $gaurd = 'projects';
        } elseif (auth('branches')->check()) {
            $causer = auth('branches')->user();
            $gaurd = 'branch';
        }
        if ($causer) {
            $activity->causer_type = $gaurd; // Type of the user (e.g., Admin, Project, Branch)
            $activity->causer_id = $causer->id; // ID of the user
        }
        $properties['attributes'] = $this->attributesToArray();
        $properties['old'] = $this->getOriginal();

        $activity->from_id = $this->form_id;
        $activity->properties = $properties;
    }

    public function inputsElemnts()
    {
        return $this->hasMany(inputsElements::class,'input_id');
    }
}
