<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Models\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class Form extends Model
{
    use HasFactory,softDeletes,LogsActivity;
    protected $fillable = [
        'branches',
        'step',
        'name',
        'periodic_onetime',
        'one_time_type',
        'one_type_send_time',
        'periodic_type',
        'dead_line_by_num_of_dayes',
        'week_day',
        'month_day',
        'quarter_start_date',
        'nex_send_date',
    ];

    protected static $logName = 'form';
    protected static $logAttributes = ['*'];
    protected static $ignoredAttributes = ['created_at', 'updated_at'];

    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->description =$eventName;
        $properties = $activity->properties->toArray();
        if (auth()->check()) {
            $causer = auth()->user();
            $gaurd = 'users';
        } elseif (auth('project')->check()) {
            $causer = auth('project')->user();
            $gaurd = 'projects';
        } elseif (auth('branches')->check()) {
            $causer = auth('branches')->user();
            $gaurd = 'branch';
        }
        if ($causer) {
            $activity->causer_type = $gaurd; // Type of the user (e.g., Admin, Project, Branch)
            $activity->causer_id = $causer->id; // ID of the user
        }
        $activity->properties = $properties;
    }
    protected static $logOnlyDirty = true;

    public function formFiles()
    {
        return $this->hasMany(FormFile::class);
    }

    public function formInputs()
    {
        return $this->hasMany(FormInput::class)->with('inputsElemnts');
    }

    public function projectForms()
    {
        return $this->hasMany(ProjectForm::class);
    }

    public function projects()
    {
        return $this->belongsToMany(Project::class, 'project_form_relations', 'form_id', 'project_id');
    }
}
