<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ProjectFormEmail extends Mailable
{
    use Queueable, SerializesModels;
    public $project_name,$form_name, $form_id, $type;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($project_name, $form_name, $form_id, $type)
    {
        $this->project_name = $project_name;
        $this->form_name = $form_name;
        $this->form_id = $form_id;
        $this->type = $type;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('emails.projectForm', [
            'project_name' => $this->project_name,
            'form_name' => $this->form_name,
            'form_id' => $this->form_id,
            'type' => $this->type,
        ]);
    }
}
