<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\ResourceCollection;

class FixedFormCollection extends ResourceCollection
{

    protected $type;

    public function __construct($resource, $type)
    {
        parent::__construct($resource);
        $this->type = $type;
    }
    public function toArray($request)
    {
        $data = $this->type == 'new' ? FixedFormResources::collection($this->collection) : ProjectFixedResources::collection($this->collection);

        return [
            'current_page' => $this->currentPage() ?? 1,
            'data' => $data,
            'first_page_url' => $this->url(1) ?? '',
            'from' => $this->firstItem() ?? 0,
            'last_page' => $this->lastPage() ?? 1,
            'last_page_url' => $this->url($this->lastPage()) ?? '',
            'links' => $data != null ? $this->linkCollection() :'',
            'next_page_url' => $this->nextPageUrl() ?? '',
            'path' => $this->path() ?? '',
            'per_page' => $this->perPage() ?? 15,
            'prev_page_url' => $this->previousPageUrl() ?? '',
            'to' => $this->lastItem() ?? 0,
            'total' => $this->total() ?? 0,
        ];
    }

    protected function linkCollection()
    {
        $links = [];

        // Previous page link
        $links[] = [
            'url' => $this->previousPageUrl(),
            'label' => '&laquo; Previous',
            'active' => $this->currentPage() > 1,
        ];

        // Page number links
        for ($i = 1; $i <= $this->lastPage(); $i++) {
            $links[] = [
                'url' => $this->url($i),
                'label' => (string) $i,
                'active' => $i == $this->currentPage(),
            ];
        }

        // Next page link
        $links[] = [
            'url' => $this->nextPageUrl(),
            'label' => 'Next &raquo;',
            'active' => $this->currentPage() < $this->lastPage(),
        ];

        return $links;
    }
}
