<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Models\Branch;
use App\Models\fixedInputsElments;
use App\Models\Form;
use App\Models\FormFixed;
use App\Models\FormInput;
use App\Models\FromFixedInputs;
use App\Models\inputsElements;
use App\Models\Project;
use App\Models\ProjectFixed;
use App\Models\ProjectForm;
use App\Models\ProjectFormInput;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use ZipArchive;
class ReportsBranchController extends Controller
{

    public function generalview()
    {
        $projects = Project::where('branch_id',auth('branches')->user()->id)->pluck('name', 'id')->prepend(trans('messages.All Projects'), 0);
        $forms = Form::orderBy('created_at', 'desc')->pluck('name', 'id');

        return view('front_end.branch.reports.genral', compact('projects', 'forms'));

    }

    public function getGeneral(Request $request)
    {
        $form = Form::where('id', $request->form_id)->first();
        $lastProjects_ids = in_array(0, $request->projects) ? Project::where('branch_id',auth('branches')->user()->id)->pluck('id')->toArray():$request->projects;
        $startDate = date('Y-m-d', strtotime($request->from_date));
        // $endDate = date('Y-m-d', strtotime($request->to_date));
        $endDate = date('Y-m-d', strtotime($request->to_date . ' +1 day'));
        $project_forms = ProjectForm::whereBetween('created_at', [$startDate, $endDate])
            ->where('form_id', $request->form_id)
            ->whereIn('project_id', $lastProjects_ids)
            ->get();
        $inputs = FormInput::where('form_id', $request->form_id)->get();
        $tbody = '<tr>';

        $thead = '<tr><th>#CODE</th><th>Project / Field</th>';
        $inputArrIds = [];
        foreach ($project_forms as $keyp => $pform) {
            $thead .= '<th>' . $pform->project->name . '-' . $pform->serial_number . '</th>';
            foreach ($pform->projectFormInputs as $keypi => $input) {
                if (!in_array($input->form_input_id, $inputArrIds)) {
                    $tbody .= '<td>' . $input->formInput->id . '</td>';
                    $tbody .= '<td>' . $input->formInput->label . '</td>';
                    $calculatedSum = 0;
                    foreach ($project_forms as $keyp2 => $pform2) {
                        $answer_value = $pform2->projectFormInputs->where('form_input_id', $input->form_input_id)->first();
                        switch ($answer_value->input_type) {
                            case 'file':
                                switch ($answer_value->file_type) {
                                    case 'application/pdf':
                                        if ($answer_value->answer) {
                                            $tdVal = '<a href="' . url($answer_value->answer) . '" target="blank"> <img width="50px" src="' . url("front_end/assets/imgs/file-icon.png") . '"></a>';
                                        } else {
                                            $tdVal = '';
                                        }
                                        $tbody .= '<td>' . $tdVal . '</td>';
                                        break;

                                    default:
                                        if ($answer_value->answer) {
                                            $tdVal = '<a href="' . url($answer_value->answer) . '" target="blank"><img width="50px" src="' . url($answer_value->answer) . '"/> </a>';
                                        } else {
                                            $tdVal = '';
                                        }
                                        $tbody .= '<td>' . $tdVal . '</td>';
                                        break;
                                }
                                break;
                            case 'checkbox':
                                $answer = $answer_value->answer != null ? json_decode($answer_value->answer, true) : [0];
                                $checkboxName = inputsElements::whereIn('id', $answer)->pluck('name')->toArray();
                                $tdVal = '';
                                if (!empty($checkboxName)) {
                                    $tdVal = '( ' . implode(' , ', $checkboxName) . ' )';
                                }
                                $tbody .= '<td>' . $tdVal . '</td>';
                                break;
                            case 'radio':
                                $answer = $answer_value->answer != null ? $answer_value->answer : 0;
                                $checkboxName = inputsElements::find($answer);
                                $tdVal = '';
                                if (!empty($checkboxName)) {
                                    $tdVal = '( ' . $checkboxName->name . ' )';
                                }
                                $tbody .= '<td>' . $tdVal . '</td>';
                                break;

                            default:
                                $tbody .= '<td>' . $answer_value->answer . '</td>';
                                break;
                        }

                        if ($answer_value->calculated == 1) {
                            $calculatedSum += $answer_value->answer;
                        } else {
                            $calculatedSum = 'N/A';
                        }
                    }

                    $tbody .= '<td>' . $calculatedSum . '</td>';

                    $inputArrIds[] = $input->form_input_id;
                }
                $tbody .= '</tr>';
            }

        }


        $thead .= '<th>Calculted Sum</th>';
        $thead .= '</tr>';


        // return $thead;
        return view('front_end.branch.reports.general_result', compact('form', 'thead', 'tbody'));
    }

    public function calculated()
    {

        $projects = Project::where('branch_id',auth('branches')->user()->id)->pluck('name', 'id')->prepend(trans('messages.All Projects'), 0);
        $forms = Form::orderBy('created_at', 'desc')->pluck('name', 'id');

        return view('front_end.branch.reports.calcualte', compact('projects', 'forms'));
    }

    public function getCalculated(Request $request)
    {
        // return $request;
        $form = Form::where('id', $request->form_id)->first();
        $lastProjects_ids = in_array(0, $request->projects) ? Project::where('branch_id',auth('branches')->user()->id)->pluck('id')->toArray():$request->projects;

        $project_forms = ProjectForm::where('form_id', $request->form_id)->whereIn('project_id', $lastProjects_ids)->pluck('id');
        $startDate = date('Y-m-d', strtotime($request->from_date));
        // $endDate = date('Y-m-d', strtotime($request->to_date));
        $endDate = date('Y-m-d', strtotime($request->to_date . ' +1 day'));
        // return $endDate;
        $inputs = ProjectFormInput::with('formInput')
            ->where(['input_type' => 'number', 'calculated' => 1])
            ->whereIn('project_form_id', $project_forms)
            ->whereBetween('created_at', [$startDate, $endDate])
            ->select('form_input_id', DB::raw('SUM(answer) as total'))
            ->groupBy('form_input_id')
            ->get();
        return view('front_end.branch.reports.calculated_result', compact('form', 'inputs'));
    }

    public function fromFiles()
    {
        $projects = Project::where('branch_id',auth('branches')->user()->id)->pluck('name', 'id')->prepend(trans('messages.All Projects'), 0);
        $forms = Form::orderBy('created_at', 'desc')->pluck('name', 'id');
        return view('front_end.branch.reports.files', compact('projects', 'forms'));
    }

    public function getFiles()
    {

        $form_id = request()->form_id;
        $form = Form::where('id', $form_id)->first();
        // check input files
        $inputId = FormInput::where([
            ['form_id', $form_id],
            ['input_type', 'file']
        ])->pluck('id')->toArray();

        if (!empty($inputId)) {
            $lastProjects_ids = in_array(0, request()->projects) ? Project::where('branch_id',auth('branches')->user()->id)->pluck('id')->toArray():request()->projects;
            $startDate = date('Y-m-d', strtotime(request()->from_date));
            $endDate = date('Y-m-d', strtotime(request()->to_date . ' +1 day'));
            $project_forms = ProjectForm::whereBetween('created_at', [$startDate, $endDate])
                ->where('form_id', $form_id)
                ->whereIn('project_id', $lastProjects_ids)
                ->get();
            // create file name
            $zipFileName = "$form->name.zip";
            $zip = new ZipArchive;
            $filesToZip=[];
            foreach ($project_forms as $pform) {
                $project_name = $pform->project->branch->name.'/'.$pform->project->name;
                $inputs = ProjectFormInput::with('formInput')->where([['project_form_id', $pform->id], ['input_type', 'file']])->get();
                if (!empty($inputs)) {
                    foreach ($inputs as $input) {
                        $path = public_path($input->answer);
                        if ($input->answer != null && file_exists($path)) {
                            $filePath = url($input->answer);
                            $fileExtension = pathinfo($filePath, PATHINFO_EXTENSION);
                            $fileName = $input->formInput->label.'--'.$input->id.'--'.$input->updated_at->format('Y-m-d').'-'.".".$fileExtension;
                            $filesToZip [$project_name][$fileName]= $input->answer;
                        }
                    }
                }
            }
            if(!empty($filesToZip))
            {
                if ($zip->open(public_path($zipFileName), ZipArchive::CREATE) === TRUE) {
                    foreach ($filesToZip as $key => $file) {
                        $project = $key;
                        foreach ($file as $key => $v) {
                            $absoluteFilePath = public_path($v);
                            $originalExtension = pathinfo($absoluteFilePath, PATHINFO_EXTENSION);
                            $name ="$project/" . $key;
                            if(file_exists($absoluteFilePath))
                            {
                                $zip->addFile($absoluteFilePath,$name);
                            }
                        }
                    }
                    $zip->close();
                    return response()->download(public_path($zipFileName))->deleteFileAfterSend(true);
                }
            }

            return redirect()->back();
        }
        return redirect()->back();
    }

    public function fixedGeneral()
    {
        $projects = Project::where('branch_id',auth('branches')->user()->id)->pluck('name', 'id')->prepend(trans('messages.All Projects'), 0);
        $forms = FormFixed::orderBy('created_at', 'desc')->pluck('name', 'id');
        return view('front_end.branch.reports.fixed.general', compact('projects', 'forms'));
    }

    public function fixedGetGeneral()
    {
        $from_id = request()->form_id;
        $form = FormFixed::where('id', $from_id)->first();
        $fromInput = FromFixedInputs::where('form_id', $form->id)->get();
        $startDate = date('Y-m-d', strtotime(request()->from_date));
        $endDate = date('Y-m-d', strtotime(request()->to_date . ' +1 day'));
        $lastProjects_ids = in_array(0, request()->projects) ? Project::where('branch_id',auth('branches')->user()->id)->pluck('id')->toArray():request()->projects;

        $project_forms = ProjectFixed::with('projectFormInputs')
            ->where('status','!=','open')
            ->whereBetween('created_at', [$startDate, $endDate])
            ->where('form_id', $from_id)
            ->whereIn('project_id', $lastProjects_ids)
            ->get();
        $tbody = '<tr>';
        $thead = '<tr><th>#CODE</th><th>Project / Field</th>';
        $inputArrIds = [];

        foreach ($project_forms as $keyp => $pform) {

            $thead .= '<th>' . $pform->project->name . '-' . $pform->form->name . '-'.$pform->created_at->format('Y-m-d') .'</th>';
            foreach ($fromInput as $keypi => $input) {
                if (!in_array($input->id, $inputArrIds)) {
                    $tbody .= '<td>' . $input->id . '</td>';
                    $tbody .= '<td>' . $input->label . '</td>';
                    foreach ($project_forms as $keyp2 => $pform2) {
                        $answer_value = $pform2->projectFormInputs->where('fixed_input_id', $input->id)->first();
                        if(!empty($answer_value))
                        {
                            switch ($answer_value->input_type) {
                                case 'file':
                                    switch ($answer_value->file_type) {
                                        case 'application/pdf':
                                            if ($answer_value->answer) {
                                                $tdVal = '<a href="' . url($answer_value->answer) . '" target="blank"> <img width="50px" src="' . url("front_end/assets/imgs/file-icon.png") . '"></a>';
                                            } else {
                                                $tdVal = '';
                                            }
                                            $tbody .= '<td>' . $tdVal . '</td>';
                                            break;

                                        default:
                                            if ($answer_value->answer) {
                                                $tdVal = '<a href="' . url($answer_value->answer) . '" target="blank"><img width="50px" src="' . url($answer_value->answer) . '"/> </a>';
                                            } else {
                                                $tdVal = '';
                                            }
                                            $tbody .= '<td>' . $tdVal . '</td>';
                                            break;
                                    }
                                    break;
                                case 'checkbox':
                                    $answer = $answer_value->answer != null ?json_decode($answer_value->answer, true) :[0];
                                    $checkboxName = fixedInputsElments::whereIn('id',$answer)->pluck('name')->toArray();
                                    $tdVal = '';
                                    if(!empty($checkboxName)){
                                        $tdVal = '( ' . implode(' , ', $checkboxName) . ' )';
                                    }
                                    $tbody .= '<td>' . $tdVal . '</td>';
                                    break;
                                case 'radio':
                                    $answer = $answer_value->answer != null ?$answer_value->answer :0;
                                    $checkboxName = fixedInputsElments::find($answer);
                                    $tdVal = '';
                                    if(!empty($checkboxName)){
                                        $tdVal = '( ' .  $checkboxName->name . ' )';
                                    }
                                    $tbody .= '<td>' . $tdVal . '</td>';
                                    break;

                                default:
                                    $tbody .= '<td>' . $answer_value->answer . '</td>';
                                    break;
                            }

                        }
                    }

                    $inputArrIds[] = $input->id;
                }
                $tbody .= '</tr>';

            }
        }

        $thead .= '</tr>';

        return view('front_end.branch.reports.fixed.general_result', compact('form', 'thead', 'tbody'));

    }
}
