<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\Branch;
use Illuminate\Http\Request;
use Auth;

class BranchAuthController extends Controller
{
    public function login(Request $request)
    {
        $credentials = $request->only('id', 'password');
        $branch= Branch::where('id', $credentials['id'])->first();
        if (!$branch || !password_verify($credentials['password'], $branch->password)) {
            return redirect()->back()->withErrors([
                'message' => 'Invalid password',
            ]);
        }
        Auth::guard('branches')->login($branch);
        return redirect()->route('branch.front.index');
    }

    public function showLoginForm()
    {
        $branches = Branch::pluck('name', 'id');
        if (sizeof($branches) > 0) {
            return view('auth.branch-login', compact('branches'));
        }
        return 'Have Errors ';
    }
}
