<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;

use App\Models\ProjectForm;
use App\Http\Requests\StoreProjectFormRequest;
use App\Http\Requests\UpdateProjectFormRequest;
use App\Mail\ProjectFormEmail;
use App\Models\Branch;
use App\Models\Form;
use App\Models\Project;
use App\Models\ProjectFormInput;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Traits\FirebaseNotification;
use Illuminate\Support\Facades\Mail;


class ProjectFormController extends Controller
{
    use FirebaseNotification;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        $project_name = $request->has('project_name') ?$request->project_name:null;
        $email_project = $request->has('email_project')?$request->email_project:null;
        $phone_project = $request->has('phone_project')?$request->phone_project:null;
        $sort_search = $request->has('search') ?$request->search :null;
        $limit=$request->has('limit')?$request->limit:15;
        $user_name = $request->has('user_name')?$request->user_name:null;
        $email_branch=$request->has('email_branch')?$request->email_branch:null;
        $phone_branch = $request->has('phone_branch')?$request->phone_branch:null;
        $branch_id=$request->has('branch_id') && $request->branch_id != 0?$request->branch_id:null;
        $project_id =$request->has('project_id') && $request->project_id != 0?$request->project_id:null;
        $status=$request->has('status') && $request->status != 'all'?$request->status:null;
        $form_id=$request->has('form_id') && $request->form_id != 0?$request->form_id:null;


        $forms = ProjectForm::orderBy('created_at', 'desc')
            ->when($sort_search, function ($query, $sort_search) {
                 $query->whereHas('form', function ($q) use ($sort_search) {
                    $q->where('name', 'like', '%' . $sort_search . '%');
                });
            })->when($project_name, function ($query, $project_name) {
                 $query->whereHas('project', function ($q) use ($project_name) {
                    $q->where('hse_manager_name', 'like', '%' . $project_name . '%');
                });
            })->when($email_project, function ($query, $email_project) {
                 $query->whereHas('project', function ($q) use ($email_project) {
                     $q->where('email', 'like', '%' .$email_project);
                 });
            })->when($phone_project, function ($query, $phone_project) {
                 $query->whereHas('project', function ($q) use ($phone_project) {
                     $q->where('phone', 'like', '%' .$phone_project);
                 });
            })->when($user_name, function ($query, $user_name) {
                 $query->whereHas('project', function ($q) use ($user_name) {
                    $q->whereHas('branch', function ($q2) use ($user_name) {
                        $q2->where('user_name', 'like', '%' . $user_name . '%');
                    });
                });
            })->when($email_branch, function ($query, $email_branch) {
                 $query->whereHas('project', function ($q) use ($email_branch) {
                    $q->whereHas('branch', function ($q2) use ($email_branch) {
                        $q2->where('email', 'like', '%' . $email_branch);
                    });
                });
            })->when($phone_branch, function ($query, $phone_branch) {
                return   $query->whereHas('project', function ($q) use ($phone_branch) {
                    $q->whereHas('branch', function ($q2) use ($phone_branch) {
                        $q2->where('phone', 'like', '%' . $phone_branch);
                    });
                });
            })->when($branch_id, function ($query, $branch_id) {
                $projectIds = Project::where('branch_id', $branch_id)->pluck('id')->toArray();
                $query->whereIn('project_id', $projectIds);
            })->when($project_id, function ($query, $project_id) {
                $query->where('project_id', $project_id);
            })->when($status, function ($query, $status) {
                $query->where('status', $status);
            })->when($form_id, function ($query, $form_id) {
                $query->where('form_id', $form_id);
            })->paginate($limit);
            /**





        if ($request->has('form_id') && $request->form_id != 0) {
            $forms = $forms->where('form_id', $request->form_id);
            $form_id = $request->form_id;
        } else {
            $form_id = $request->form_id;
        }
        **/
        //$forms = $forms->paginate($limit);
        //$forms = $forms->get();
        $branches = Branch::get();
        $originalForms = Form::pluck('name', 'id')->prepend(trans('messages.All Forms'), 0);
        return view('admin.projectForm.index', compact('phone_project','phone_branch','email_branch','user_name','email_project','forms','project_name' ,'originalForms', 'branches', 'branch_id', 'project_id', 'form_id', 'status', 'sort_search'));
    }

    public function pdfDownload($id)
    {
        $form = ProjectForm::where('id', $id)
            ->with('form.formFiles')
            ->first();
        $fromInput = ProjectFormInput::with('formInput')
            ->where('project_form_id', $id)
            ->get()->toArray();

        return view('admin.projectForm.pdf', compact('form','fromInput'));

    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreProjectFormRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreProjectFormRequest $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\ProjectForm  $projectForm
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $projectForm = ProjectForm::where('id', $id)
            ->with('form.formFiles')
            ->first();
        $formInputs = ProjectFormInput::with('formInput')
            ->where('project_form_id', $id)
            ->get();
        return view('admin.projectForm.show', compact('projectForm', 'formInputs'));
    }

    public function updateExpiration()
    {
        $forms = ProjectForm::where('expiration_date', '<', Carbon::now())->whereIn('status', ['waiting', 'incomplete'])->get();
        foreach ($forms as $key => $form) {
            $form->status = 'expired';
            $form->save();
            //send notifications and mail
            $title = "Hello, " . $form->project->name;
            $type = "form_expired";
            $form_id = $form->id;
            $message = "Hello, " . $form->project->name . "Form " . $form->name . "Petrojet HSE form builder Expired soon Hury to fill it now.";
            if ($form->project->fcm_token) {
                $this->sendNotification($form->project->id, $title, $message, $type, $form_id);
            }
            if ($form->project->email) {
                try {
                    Mail::to($form->project->email)->send(new ProjectFormEmail($form->project->name, $form->form->name, $form_id, $type));
                } catch (\Swift_TransportException $e) {
                    //throw $th;
                }
            }
        }
        return response()->json(['success' => true]);
    }

    public function publishForms()
    {
        $publishForms = Form::where('periodic_onetime', 'periodic')->where('nex_send_date', date('Y-m-d'))->get();
        foreach ($publishForms as $key => $form) {
            foreach ($form->projects as $project) {
                switch ($form->periodic_type) {
                    case 'week':
                        $form->nex_send_date = date('Y-m-d', strtotime('+7 day'));
                        break;
                    case 'month':
                        $form->nex_send_date = date('Y-m-d', strtotime('+31 day'));
                        break;
                    case 'quarter':
                        $form->nex_send_date = date('Y-m-d', strtotime('+91 day'));
                        break;
                    default:
                        # code...
                        break;
                }
                $form->save();
                $now = Carbon::now();
                $date = $now->addDays($form->dead_line_by_num_of_dayes);
                $projectForm = new ProjectForm;
                $projectForm->serial_number = Str::random(10);
                $projectForm->project_id = $project->id;
                $projectForm->form_id = $form->id;
                $projectForm->expiration_date = $date;
                // return $projectForm;
                $projectForm->save();
                foreach ($form->formInputs as $key => $value) {
                    $projectFormInput = new ProjectFormInput;
                    $projectFormInput->project_form_id = $projectForm->id;
                    $projectFormInput->form_input_id = $value->id;
                    $projectFormInput->input_type = $value->input_type;
                    $projectFormInput->calculated = $value->calculated;
                    $projectFormInput->answer = ($value->calculated == 1) ? 0 : null;
                    $projectFormInput->save();
                }
                //send notifications and mail
                $title = "Hello, " . $project->name;
                $type = "fill_form";
                $form_id = $projectForm->id;
                $message = "Hello, " . $project->name . "New Publishable Form " . $form->name . "Petrojet HSE form builder should be filled";
                if ($project->fcm_token) {
                    $this->sendNotification($project->id, $title, $message, $type, $form_id);
                }
                if ($project->email) {
                    try {
                        Mail::to($project->email)->send(new ProjectFormEmail($project->name, $form->name, $form_id, $type));
                    } catch (\Swift_TransportException $e) {
                        //throw $th;
                    }
                }
            }
        }
        $oneTimeForms = Form::where(['periodic_onetime' => 'onetime', 'one_time_type' => 'spacific'])->where('one_type_send_time', date('Y-m-d'))->get();
        foreach ($oneTimeForms as $key => $value) {
            foreach ($value->projects as $project) {
                $now = Carbon::now();
                $date = $now->addDays($value->dead_line_by_num_of_dayes);
                $projectForm = new ProjectForm;
                $projectForm->serial_number = Str::random(10);
                $projectForm->project_id = $project->id;
                $projectForm->form_id = $value->id;
                $projectForm->expiration_date = $date;
                $projectForm->save();
                foreach ($value->formInputs as $key => $value2) {
                    $projectFormInput = new ProjectFormInput;
                    $projectFormInput->project_form_id = $projectForm->id;
                    $projectFormInput->form_input_id = $value2->id;
                    $projectFormInput->input_type = $value2->input_type;
                    $projectFormInput->calculated = $value2->calculated;
                    $projectFormInput->answer = ($value2->calculated == 1) ? 0 : null;
                    $projectFormInput->save();
                }
                $value->one_type_send_time = null;
                $value->save();
                //send notifications and mail
                $title = "Hello, " . $project->name;
                $type = "fill_form";
                $form_id = $projectForm->id;
                $message = "Hello, " . $project->name . "New Publishable Form " . $value->name . "Petrojet HSE form builder should be filled";
                if ($project->fcm_token) {
                    $this->sendNotification($project->id, $title, $message, $type, $form_id);
                }
                if ($project->email) {
                    try {
                        Mail::to($project->email)->send(new ProjectFormEmail($project->name, $value->name, $form_id, $type));
                    } catch (\Swift_TransportException $e) {
                        //throw $th;
                    }
                }
            }
        }

        return response()->json(['success' => true]);
    }
    public function del($id)
    {
        $form = ProjectForm::find($id);
        if(!empty($form))
        {
            $form->delete();
            return redirect()->back();
        }
        return redirect()->back();
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\ProjectForm  $projectForm
     * @return \Illuminate\Http\Response
     */
    public function edit(ProjectForm $projectForm)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateProjectFormRequest  $request
     * @param  \App\Models\ProjectForm  $projectForm
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateProjectFormRequest $request, ProjectForm $projectForm)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\ProjectForm  $projectForm
     * @return \Illuminate\Http\Response
     */
    public function destroy(ProjectForm $projectForm)
    {
        //
    }
}
