<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Spatie\Activitylog\Models\Activity;

class LogActivityControllers extends Controller
{

    private $notShowing=[
        "created_at",
        "updated_at",
        "branch_id",
        "form_id",
        "project_id",
        "id",
        "project_fixed_id",
        "fixed_input_id",
        "calculated",
        "form_id",
        "fcm_token"

    ];
    private $withRealtion = [
        'projectForm'=>['subject','causer','subject.form'],
    ];


    public function index()
    {
        return view('admin.logActivity.index')->with('activity',[]);
    }

    public function search()
    {

        $inlog = request()->name;
        if(in_array($inlog,["projectForm","projectFixed"]))
        {
            $activity =  Activity::with(['subject','causer','subject.form'])->inLog($inlog)->orderBy('updated_at','desc')->paginate(15);
        }else{
            $activity =  Activity::with(['subject','causer'])->inLog($inlog)->orderBy('updated_at','desc')->paginate(15);
        }
        return view('admin.logActivity.index')
            ->with('inlog',$inlog)
            ->with('activity',$activity);
    }

    public function show($id,$inlog)
    {

        if(in_array($inlog,["projectForm","projectFixed"]))
        {
            $long = $inlog == "projectForm" ? 'ProjectFormInput':'ProjectFixedInput';
            $archives = Activity::with(['subject','causer','subject.form'])->find($id);
            $projectInput =  Activity::with(['subject','causer','subject.formInput'])->inLog($long)->where('from_id',$archives->subject_id)->orderBy('updated_at','desc')->paginate(15);
            return view('admin.logActivity.projectForm')
                ->with('inlog',$archives->log_name)
                ->with('projectInput',$projectInput)
                ->with('notShowing',$this->notShowing)
                ->with('archives',$archives);
        }

        if(in_array($inlog,["form","fixed"]))
        {
            $long = $inlog == "form" ? 'fromInput':'fixedInput';
            $archives = Activity::with(['subject','causer'])->find($id);
            $projectInput =  Activity::with(['subject','causer','subject.inputsElemnts'])->inLog($long)->where('from_id',$archives->subject_id)->orderBy('updated_at','desc')->paginate(15);
            return view('admin.logActivity.form')
                ->with('inlog',$archives->log_name)
                ->with('projectInput',$projectInput)
                ->with('notShowing',$this->notShowing)
                ->with('archives',$archives);
        }
        $archives = Activity::with(['causer'])->find($id);
        return view('admin.logActivity.show')
            ->with('inlog',$archives->log_name)
            ->with('notShowing',$this->notShowing)
            ->with('archives',$archives);
    }
}
