<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreFormFileRequest;
use App\Models\FormFixedFile;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class FormFixedFileController extends Controller
{

    public function index(Request $request)
    {
        $files = FormFixedFile::where('temp_serial', $request->temp_serial)->get();
        return view('admin.formFixed.partials.files', compact('files'));
    }
    public function store(StoreFormFileRequest $request)
    {
        $file = $request->file('file');
        $uploadedFile = saveFormFile($file);
        if ($uploadedFile['success'] == true) {
            $formFile = new FormFixedFile();
            $formFile->temp_serial  = $request->temp_serial;
            $formFile->type  = $uploadedFile['file_type'];
            $formFile->file_path  = 'uploads/formFiles/' . $uploadedFile['file_name'];
            $formFile->save();
            return response()->json(['success' => true, 'data' => $uploadedFile]);
        } else {
            return response()->json(['success' => false, 'data' => null]);
        }
    }

    public function deleted(Request $request)
    {
        // return $formFile;
        $formFile = FormFixedFile::where('id', $request->id)->first();
        if ($formFile->file_path && file_exists(public_path($formFile->file_path))) {
            unlink(public_path($formFile->file_path));
        }
        $formFile->delete();
        $files = FormFixedFile::where('temp_serial', Session::get('temp_serial'))->get();
        return view('admin.formFixed.partials.files', compact('files'));
    }
}
