<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Branch;
use App\Models\fixedInputsElments;
use App\Models\FormFixed;
use App\Models\FormFixedFile;
use App\Models\FromFixedInputs;
use App\Models\Project;
use App\Models\ProjectFixed;
use App\Models\ProjectFixedInput;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;
use Maatwebsite\Excel\Facades\Excel;

class FormFixedController extends Controller
{

    public function index()
    {
        $forms = FormFixed::orderBy('created_at', 'desc');
        if (request()->has('search')) {
            $sort_search = request()->search;
            $forms = $forms->where('name', 'like', '%' . $sort_search . '%');
        }
        $forms = $forms->paginate(15);

        return view('admin.formFixed.index', compact('forms'));
    }

    public function create(Request $request){
        if (!$request->session()->has('temp_serial_fixed')) {
            $temp_serial = Str::random(10);
            $request->session()->put('temp_serial_fixed', $temp_serial);
        }
        $baranchs = Branch::all();
        return view('admin.formFixed.create')
            ->with('baranchs',$baranchs);
    }

    public function addField(Request $request)
    {
        $inputCounter = $request->inputCounter;
        return view('admin.formFixed.partials.field', compact('inputCounter'));
    }

    public function uploadFieldsFile(Request $request)
    {
        if ($request->has('getCounterUpdate')) {
            $file = $request->file('file');
            $data = Excel::toArray([], $file)[0];
            $inputCounter = $request->inputCounter;
            return $inputCounter + sizeof($data);
        } else {
            $file = $request->file('file');
            $data = Excel::toArray([], $file)[0];
            $inputCounter = $request->inputCounter;
            return view('admin.formFixed.partials.fields', compact('inputCounter', 'data'));
        }
    }

    public function getProjectsByBranch(Request $request)
    {
        $projects = Project::where('branch_id', $request->branch_id)->pluck('name', 'id')->prepend(trans('messages.All Projects'), 0);
        $branch = Branch::where('id', $request->branch_id)->first();
        return view('admin.project.partial.get_projects_by_branch', compact('projects', 'branch'));
    }

    public function store(Request $request)
    {


        $form = new FormFixed();
        $form->step = 'registereed';
        $form->name = $request->name;
        $form->desc = $request->desc;
        $form->title_print = $request->title_print;
        $form->footer_print = $request->footer_print;
        $form->approved = $request->has('approval') ? 1 : 0;
        $form->save();
        foreach ($request->inputs as $key => $value) {
            $formInputs = new FromFixedInputs();
            $formInputs->form_id  = $form->id;
            $formInputs->label  = $value['label'];
            $formInputs->input_type  = $value['input_type'];
            $formInputs->placeholder  = isset($value['placeholder'])?$value['placeholder']:null;
            $formInputs->value  = isset($value['value']) ? $value['value'] : null;
            $formInputs->calculated  = 0;
            $formInputs->required  = (isset($value['files_required'])) ? true : false;
            $formInputs->save();
            if(in_array($value['input_type'],['radio','checkbox']))
            {
                foreach ($value[$formInputs->input_type] as $in)
                {
                    $elments = new fixedInputsElments();
                    $elments->input_id = $formInputs->id;
                    $elments->name = $in;
                    $elments->save();
                }
            }
        }
        if (Session::has('temp_serial_fixed')) {
            FormFixedFile::where('temp_serial', Session::get('temp_serial_fixed'))
                ->update(['form_id' => $form->id]);
            Session::forget('temp_serial_fixed');
        }

        return redirect()->route('fixed.index');
    }

    public function destroy(FormFixed $form)
    {


        $form->delete();
        /*
        if($form->step == "registereed")
        {
            $formFiles = FormFixedFile::where('form_id', $form->id)->get();
            foreach ($formFiles as $key => $formFile) {
                if ($formFile->file_path && file_exists(public_path($formFile->file_path))) {
                    unlink(public_path($formFile->file_path));
                }
            }
            fixedInputsElments::where('form_id',$form->id)->delete();
            FromFixedInputs::where('form_id',$form->id)->delete();
            $form->delete();
            session()->flash('notif', trans('messages.Form deleted successfully'));
            return redirect()->route('fixed.index');
        }*/
        //session()->flash('notif', trans('This Form is Cant removed'));
        session()->flash('notif', trans('messages.Form deleted successfully'));
        return redirect()->route('fixed.index');
    }

    public function show(FormFixed $form)
    {

        return view('admin.formFixed.show', compact('form'));
    }

    public function sended(Request $request)
    {
        $name =$request->has('search')?$request->search:null;
        $limit=$request->has('limit')?$request->limit:15;
        $phone_branch=$request->has('phone_branch')?$request->phone_branch:null;
        $phone_project=$request->has('phone_project')?$request->phone_branch:null;
        $user_name =$request->has('user_name')?$request->user_name:null;
        $email_branch =$request->has('email_branch')?$request->email_branch:null;
        $project_name =$request->has('project_name')?$request->project_name:null;
        $email_project =$request->has('email_project')?$request->email_project:null;
        $status =$request->has('status') && $request->status != 'all'? $request->status:null;
        $branch_id =$request->has('branch_id') && $request->branch_id !=0? $request->branch_id:null;
        $project_id =$request->has('project_id') && $request->project_id!=0? $request->project_id:null;
        $form_id =$request->has('form_id') &&  $request->form_id!=0? $request->form_id:null;
        $forms = ProjectFixed::with('Form', 'Project', 'Branch')
            ->when($status, function ($q, $status) {
                $statuses = explode(',', $status);
                  if (in_array('waiting', $statuses)) {
                      $statuses[] = 'open';
                  }
                $q->whereIn('status', $statuses);
            })
            ->when($name, function ($q, $name) {
                $q->whereHas('Form', function ($q) use ($name) {
                    $q->where('name', 'like', '%' . $name . '%');
                });
            })->when($user_name, function ($q, $user_name) {
                $q->whereHas('Branch', function ($q) use ($user_name) {
                    $q->where('user_name', 'like', '%' . $user_name . '%');
                });
            })->when($email_branch, function ($q, $email_branch) {
                $q->whereHas('Branch', function ($q) use ($email_branch) {
                    $q->where('email', 'like', '%' . $email_branch . '%');
                });
            })->when($phone_branch, function ($q, $phone_branch) {
                $q->whereHas('Branch', function ($q) use ($phone_branch) {
                    $q->where('phone', 'like', '%' . $phone_branch);
                });
            })->when($project_name, function ($q, $project_name) {
                $q->whereHas('Project', function ($q) use ($project_name) {
                    $q->where('hse_manager_name', 'like', '%' . $project_name . '%');
                });
            })->when($phone_project, function ($q, $phone_project) {
                $q->whereHas('Project', function ($q) use ($phone_project) {
                    $q->where('phone', 'like', '%' . $phone_project . '%');
                });
            })->when($email_project, function ($q, $email_project) {
                $q->whereHas('Project', function ($q) use ($email_project) {
                    $q->where('email', 'like', '%' . $email_project . '%');
                });
            })->when($branch_id, function ($q) use ($branch_id) {
                $q->where('branch_id', $branch_id);
            })->when($project_id, function ($q) use ($project_id) {
                $q->where('project_id', $project_id);
            })->when($form_id, function ($q) use ($form_id) {
                $q->where('form_id', $form_id);
            })->orderBy('updated_at', 'desc')
            ->paginate($limit);

            $branches = Branch::get();
            $originalForms = FormFixed::pluck('name', 'id')->prepend(trans('messages.All Forms'), 0);

           return view('admin.formFixed.sended', compact('originalForms','forms', 'branches'));
    }

    public function showSended($id)
    {
        $projectForm = ProjectFixed::with('Form','Form.formFiles', 'Project', 'Branch')
            ->find($id);
        $formInputs = ProjectFixedInput::where('project_fixed_id', $id)->get();

        return view('admin.formFixed.sended-show', compact('projectForm', 'formInputs'));

    }

    public function pdfDownload($id)
    {
        $form = ProjectFixed::with('Form')->find($id);
        $fromInput = ProjectFixedInput::with('formInput')->where('project_fixed_id', $id)->get()->toArray();
        return view('admin.formFixed.pdf', compact('form','fromInput'));
    }

    public function del($id)
    {
        $form = ProjectFixed::find($id);
        if(!empty($form))
        {
            $form->delete();
            return redirect()->back();
        }
        return redirect()->back();
    }


}
