<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Branch;
use App\Models\fixedInputsElments;
use App\Models\FormFixed;
use App\Models\FromFixedInputs;
use App\Models\Project;
use App\Models\ProjectFixed;
use App\Models\ProjectForm;

class FixedReportController extends Controller
{

    public function general()
    {
        $branches = Branch::pluck('name', 'id')->prepend(trans('messages.All Branches'), 0);
        $projects = Project::pluck('name', 'id')->prepend(trans('messages.All Projects'), 0);
        $forms = FormFixed::pluck('name', 'id');
        return view('admin.fixedReport.general', compact('branches', 'projects', 'forms'));
    }

    public function getGeneral()
    {
        $from_id = request()->form_id;
        $form = FormFixed::where('id', $from_id)->first();
        $fromInput = FromFixedInputs::where('form_id', $form->id)->get();
        $startDate = date('Y-m-d', strtotime(request()->from_date));
        $endDate = date('Y-m-d', strtotime(request()->to_date . ' +1 day'));
        if (in_array(0, request()->branches)) {
            $lastProjects_ids = Project::pluck('id')->toArray();
        } else {
            $projects_ids = [];
            foreach (request()->projects as $key => $projects) {
                if (in_array(0, $projects)) {
                    $projects_ids_push = Project::where('branch_id', $key)->pluck('id')->toArray(); //get all branch projects as array
                    array_push($projects_ids, $projects_ids_push);
                } else {
                    array_push($projects_ids, array_map('intval', $projects));
                }
            }
            $lastProjects_ids = array_merge(...$projects_ids);
        }
        $project_forms = ProjectFixed::with('projectFormInputs')
            ->where('status','!=','open')
            ->whereBetween('created_at', [$startDate, $endDate])
            ->where('form_id', $from_id)
            ->whereIn('project_id', $lastProjects_ids)
            ->get();
        $tbody = '<tr>';
        $thead = '<tr><th>#CODE</th><th>Project / Field</th>';
        $inputArrIds = [];

        foreach ($project_forms as $keyp => $pform) {

            $thead .= '<th>' . $pform->project->name . '-' . $pform->form->name . '-'.$pform->created_at->format('Y-m-d') .'</th>';
            foreach ($fromInput as $keypi => $input) {
                if (!in_array($input->id, $inputArrIds)) {
                    $tbody .= '<td>' . $input->id . '</td>';
                    $tbody .= '<td>' . $input->label . '</td>';
                    foreach ($project_forms as $keyp2 => $pform2) {
                        $answer_value = $pform2->projectFormInputs->where('fixed_input_id', $input->id)->first();
                        if(!empty($answer_value))
                        {
                            switch ($answer_value->input_type) {
                                case 'file':
                                    switch ($answer_value->file_type) {
                                        case 'application/pdf':
                                            if ($answer_value->answer) {
                                                $tdVal = '<a href="' . url($answer_value->answer) . '" target="blank"> <img width="50px" src="' . url("front_end/assets/imgs/file-icon.png") . '"></a>';
                                            } else {
                                                $tdVal = '';
                                            }
                                            $tbody .= '<td>' . $tdVal . '</td>';
                                            break;

                                        default:
                                            if ($answer_value->answer) {
                                                $tdVal = '<a href="' . url($answer_value->answer) . '" target="blank"><img width="50px" src="' . url($answer_value->answer) . '"/> </a>';
                                            } else {
                                                $tdVal = '';
                                            }
                                            $tbody .= '<td>' . $tdVal . '</td>';
                                            break;
                                    }
                                    break;
                                case 'checkbox':
                                    $answer = $answer_value->answer != null ?json_decode($answer_value->answer, true) :[0];
                                    $checkboxName = fixedInputsElments::whereIn('id',$answer)->pluck('name')->toArray();
                                    $tdVal = '';
                                    if(!empty($checkboxName)){
                                        $tdVal = '( ' . implode(' , ', $checkboxName) . ' )';
                                    }
                                    $tbody .= '<td>' . $tdVal . '</td>';
                                    break;
                                case 'radio':
                                    $answer = $answer_value->answer != null ?$answer_value->answer :0;
                                    $checkboxName = fixedInputsElments::find($answer);
                                    $tdVal = '';
                                    if(!empty($checkboxName)){
                                        $tdVal = '( ' .  $checkboxName->name . ' )';
                                    }
                                    $tbody .= '<td>' . $tdVal . '</td>';
                                    break;

                                default:
                                    $tbody .= '<td>' . $answer_value->answer . '</td>';
                                    break;
                            }

                        }
                    }

                    $inputArrIds[] = $input->id;
                }
                $tbody .= '</tr>';

            }
        }

        $thead .= '</tr>';

        return view('admin.fixedReport.general_result', compact('form', 'thead', 'tbody'));


    }
}
